/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.spi.serialization;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ehcache.config.SerializerConfiguration;
import org.ehcache.config.serializer.DefaultSerializationProviderConfiguration;
import org.ehcache.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.exceptions.CachePersistenceException;
import org.ehcache.internal.serialization.CompactJavaSerializer;
import org.ehcache.internal.serialization.CompactPersistentJavaSerializer;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.UnsupportedTypeException;
import org.ehcache.spi.service.FileBasedPersistenceContext;
import org.ehcache.spi.service.LocalPersistenceService;
import org.ehcache.spi.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSerializationProvider
implements SerializationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSerializationProvider.class);
    private final TransientProvider transientProvider;
    private final PersistentProvider persistentProvider;

    public DefaultSerializationProvider(DefaultSerializationProviderConfiguration configuration) {
        if (configuration != null) {
            this.transientProvider = new TransientProvider(configuration.getTransientSerializers());
            this.persistentProvider = new PersistentProvider(configuration.getPersistentSerializers());
        } else {
            this.transientProvider = new TransientProvider(Collections.<String, Class<Serializer<?>>>emptyMap());
            this.persistentProvider = new PersistentProvider(Collections.emptyMap());
        }
    }

    public <T> Serializer<T> createKeySerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
        if (ServiceLocator.findSingletonAmongst(LocalPersistenceService.PersistenceSpaceIdentifier.class, (Object[])configs) == null) {
            return this.transientProvider.createKeySerializer(clazz, classLoader, configs);
        }
        return this.persistentProvider.createKeySerializer(clazz, classLoader, configs);
    }

    public <T> Serializer<T> createValueSerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
        if (ServiceLocator.findSingletonAmongst(LocalPersistenceService.PersistenceSpaceIdentifier.class, (Object[])configs) == null) {
            return this.transientProvider.createValueSerializer(clazz, classLoader, configs);
        }
        return this.persistentProvider.createValueSerializer(clazz, classLoader, configs);
    }

    public void start(ServiceProvider serviceProvider) {
        this.transientProvider.start(serviceProvider);
        this.persistentProvider.start(serviceProvider);
    }

    public void stop() {
        this.transientProvider.stop();
        this.persistentProvider.stop();
    }

    private static <T> DefaultSerializerConfiguration<T> find(SerializerConfiguration.Type type, ServiceConfiguration<?> ... serviceConfigurations) {
        DefaultSerializerConfiguration result = null;
        Collection serializationProviderConfigurations = ServiceLocator.findAmongst(DefaultSerializerConfiguration.class, (Object[])serviceConfigurations);
        for (DefaultSerializerConfiguration serializationProviderConfiguration : serializationProviderConfigurations) {
            if (serializationProviderConfiguration.getType() != type) continue;
            if (result != null) {
                throw new IllegalArgumentException("Duplicate " + type + " serialization provider : " + serializationProviderConfiguration);
            }
            result = serializationProviderConfiguration;
        }
        return result;
    }

    static abstract class AbstractProvider
    implements SerializationProvider {
        protected final Map<String, Class<? extends Serializer<?>>> serializers;

        private AbstractProvider(Map<String, Class<? extends Serializer<?>>> serializers) {
            this.serializers = new LinkedHashMap(serializers);
        }

        public <T> Serializer<T> createKeySerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
            DefaultSerializerConfiguration conf = DefaultSerializationProvider.find(SerializerConfiguration.Type.KEY, configs);
            return this.createSerializer("-Key", clazz, classLoader, conf, configs);
        }

        public <T> Serializer<T> createValueSerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
            DefaultSerializerConfiguration conf = DefaultSerializationProvider.find(SerializerConfiguration.Type.VALUE, configs);
            return this.createSerializer("-Value", clazz, classLoader, conf, configs);
        }

        protected abstract <T> Serializer<T> createSerializer(String var1, Class<T> var2, ClassLoader var3, DefaultSerializerConfiguration<T> var4, ServiceConfiguration<?> ... var5) throws UnsupportedTypeException;

        protected <T> Class<? extends Serializer<T>> getClassFor(String alias, DefaultSerializerConfiguration<T> config, ClassLoader classLoader) throws UnsupportedTypeException {
            Class<?> targetSerializedClass;
            Class configured;
            if (config != null && (configured = config.getClazz()) != null) {
                return configured;
            }
            Class<? extends Serializer<?>> direct = this.serializers.get(alias);
            if (direct != null) {
                return direct;
            }
            try {
                targetSerializedClass = Class.forName(alias, true, classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Configured type class '" + alias + "' not found", cnfe);
            }
            for (Map.Entry<String, Class<Serializer<?>>> entry : this.serializers.entrySet()) {
                try {
                    Class<?> configuredSerializedClass = Class.forName(entry.getKey(), true, classLoader);
                    if (!configuredSerializedClass.isAssignableFrom(targetSerializedClass)) continue;
                    return entry.getValue();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException("Configured type class '" + entry.getKey() + "' for serializer '" + entry.getValue() + "' not found", cnfe);
                }
            }
            throw new UnsupportedTypeException("No serializer found for type '" + alias + "'");
        }

        protected <T> Serializer<T> constructSerializer(Class<T> clazz, Constructor<? extends Serializer<T>> constructor, Object ... args) {
            try {
                Serializer<T> serializer = constructor.newInstance(args);
                LOG.info("Serializer for <{}> : {}", (Object)clazz.getName(), serializer);
                return serializer;
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public void stop() {
        }
    }

    static class PersistentProvider
    extends AbstractProvider {
        private volatile LocalPersistenceService persistence;

        private PersistentProvider(Map<String, Class<? extends Serializer<?>>> serializers) {
            super(serializers);
        }

        @Override
        protected <T> Serializer<T> createSerializer(String suffix, Class<T> clazz, ClassLoader classLoader, DefaultSerializerConfiguration<T> config, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
            String alias = config != null ? null : clazz.getName();
            try {
                Class<Serializer<T>> klazz = this.getClassFor(alias, config, classLoader);
                try {
                    Constructor<Serializer<T>> constructor = klazz.getConstructor(ClassLoader.class, FileBasedPersistenceContext.class);
                    LocalPersistenceService.PersistenceSpaceIdentifier space = (LocalPersistenceService.PersistenceSpaceIdentifier)ServiceLocator.findSingletonAmongst(LocalPersistenceService.PersistenceSpaceIdentifier.class, (Object[])configs);
                    FileBasedPersistenceContext context = this.persistence.createPersistenceContextWithin(space, DefaultSerializationProvider.class.getSimpleName() + suffix);
                    return this.constructSerializer(clazz, constructor, classLoader, context);
                }
                catch (NoSuchMethodException e) {
                    Constructor<Serializer<T>> constructor = klazz.getConstructor(ClassLoader.class);
                    return this.constructSerializer(clazz, constructor, classLoader);
                }
                catch (CachePersistenceException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public void start(ServiceProvider serviceProvider) {
            this.persistence = (LocalPersistenceService)serviceProvider.getService(LocalPersistenceService.class);
            if (!this.serializers.containsKey(Serializable.class.getName())) {
                this.serializers.put(Serializable.class.getName(), CompactPersistentJavaSerializer.class);
            }
        }
    }

    static class TransientProvider
    extends AbstractProvider {
        public TransientProvider(Map<String, Class<? extends Serializer<?>>> serializers) {
            super(serializers);
        }

        @Override
        protected <T> Serializer<T> createSerializer(String suffix, Class<T> clazz, ClassLoader classLoader, DefaultSerializerConfiguration<T> config, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
            String alias = config != null ? null : clazz.getName();
            try {
                Class<Serializer<T>> klazz = this.getClassFor(alias, config, classLoader);
                return this.constructSerializer(clazz, klazz.getConstructor(ClassLoader.class), classLoader);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public void start(ServiceProvider serviceProvider) {
            if (!this.serializers.containsKey(Serializable.class.getName())) {
                this.serializers.put(Serializable.class.getName(), CompactJavaSerializer.class);
            }
        }
    }
}

