/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.spi.copy;

import java.util.Collection;
import org.ehcache.config.copy.CopierConfiguration;
import org.ehcache.config.copy.DefaultCopierConfiguration;
import org.ehcache.config.copy.DefaultCopyProviderConfiguration;
import org.ehcache.internal.classes.ClassInstanceProvider;
import org.ehcache.internal.copy.IdentityCopier;
import org.ehcache.internal.copy.SerializingCopier;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.copy.CopyProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCopyProvider
extends ClassInstanceProvider<Copier<?>>
implements CopyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCopyProvider.class);

    public DefaultCopyProvider(DefaultCopyProviderConfiguration configuration) {
        super(configuration, DefaultCopierConfiguration.class);
    }

    public <T> Copier<T> createKeyCopier(Class<T> clazz, Serializer<T> serializer, ServiceConfiguration<?> ... configs) {
        return this.createCopier(CopierConfiguration.Type.KEY, clazz, serializer, configs);
    }

    public <T> Copier<T> createValueCopier(Class<T> clazz, Serializer<T> serializer, ServiceConfiguration<?> ... configs) {
        return this.createCopier(CopierConfiguration.Type.VALUE, clazz, serializer, configs);
    }

    private <T> Copier<T> createCopier(CopierConfiguration.Type type, Class<T> clazz, Serializer<T> serializer, ServiceConfiguration<?> ... configs) {
        DefaultCopierConfiguration<T> conf = DefaultCopyProvider.find(type, configs);
        Object copier = conf != null && conf.getInstance() != null ? conf.getInstance() : (conf != null && conf.getClazz().isAssignableFrom(SerializingCopier.class) ? new SerializingCopier<T>(serializer) : this.createCopier(clazz, conf));
        LOG.info("Copier for <{}> : {}", (Object)clazz.getName(), copier);
        return copier;
    }

    private <T> Copier<T> createCopier(Class<T> clazz, DefaultCopierConfiguration<T> config) {
        String alias = config != null ? null : clazz.getName();
        IdentityCopier copier = (IdentityCopier)this.newInstance(alias, (ServiceConfiguration<?>)config);
        if (copier == null) {
            copier = new IdentityCopier();
        }
        return copier;
    }

    private static <T> DefaultCopierConfiguration<T> find(CopierConfiguration.Type type, ServiceConfiguration<?> ... serviceConfigurations) {
        DefaultCopierConfiguration result = null;
        Collection copierConfigurations = ServiceLocator.findAmongst(DefaultCopierConfiguration.class, (Object[])serviceConfigurations);
        for (DefaultCopierConfiguration copierConfiguration : copierConfigurations) {
            if (copierConfiguration.getType() != type) continue;
            if (result != null) {
                throw new IllegalArgumentException("Duplicate " + type + " copier : " + copierConfiguration);
            }
            result = copierConfiguration;
        }
        return result;
    }
}

