/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.loaderwriter.writebehind;

import java.util.ArrayList;
import java.util.List;
import org.ehcache.function.BiFunction;
import org.ehcache.internal.concurrent.ConcurrentHashMap;
import org.ehcache.loaderwriter.writebehind.AbstractWriteBehindQueue;
import org.ehcache.loaderwriter.writebehind.operations.SingleOperation;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.WriteBehindConfiguration;

public class LocalHeapWriteBehindQueue<K, V>
extends AbstractWriteBehindQueue<K, V> {
    private List<SingleOperation<K, V>> waiting = new ArrayList<SingleOperation<K, V>>();
    private final ConcurrentHashMap<K, SingleOperation<K, V>> latestOperation = new ConcurrentHashMap();

    LocalHeapWriteBehindQueue(WriteBehindConfiguration config, CacheLoaderWriter<K, V> cacheLoaderWriter) {
        super(config, cacheLoaderWriter);
    }

    @Override
    protected SingleOperation<K, V> getLatestOperation(K key) {
        return this.latestOperation.get(key);
    }

    @Override
    protected void removeOperation(final SingleOperation<K, V> operation) {
        this.latestOperation.computeIfPresent(operation.getKey(), new BiFunction<K, SingleOperation<K, V>, SingleOperation<K, V>>(){

            public SingleOperation<K, V> apply(K t, SingleOperation<K, V> oldOperation) {
                if (oldOperation == null) {
                    return null;
                }
                if (oldOperation == operation) {
                    return null;
                }
                return oldOperation;
            }
        });
    }

    @Override
    protected List<SingleOperation<K, V>> quarantineItems() {
        List<SingleOperation<K, V>> quarantined = this.waiting;
        this.waiting = new ArrayList<SingleOperation<K, V>>();
        return quarantined;
    }

    @Override
    protected void addItem(SingleOperation<K, V> operation) {
        this.latestOperation.put(operation.getKey(), operation);
        this.waiting.add(operation);
    }

    @Override
    protected void reinsertUnprocessedItems(List<SingleOperation<K, V>> operations) {
        ArrayList<SingleOperation<K, V>> newQueue = new ArrayList<SingleOperation<K, V>>(operations);
        newQueue.addAll(this.waiting);
        this.waiting = newQueue;
    }

    @Override
    public long getQueueSize() {
        return this.waiting.size();
    }
}

