/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.internal.store.disk.OffHeapDiskStore;
import org.ehcache.internal.store.heap.OnHeapStore;
import org.ehcache.internal.store.offheap.OffHeapStore;
import org.ehcache.internal.store.tiering.CacheStore;
import org.ehcache.internal.store.tiering.CacheStoreServiceConfiguration;
import org.ehcache.internal.store.tiering.CompoundCachingTier;
import org.ehcache.internal.store.tiering.CompoundCachingTierServiceConfiguration;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.util.ConcurrentWeakIdentityHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceDependencies(value={CacheStore.Provider.class, CompoundCachingTier.Provider.class, OnHeapStore.Provider.class, OffHeapStore.Provider.class, OffHeapDiskStore.Provider.class})
public class DefaultStoreProvider
implements Store.Provider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStoreProvider.class);
    private volatile ServiceProvider serviceProvider;
    private final ConcurrentMap<Store<?, ?>, Store.Provider> providersMap = new ConcurrentWeakIdentityHashMap();

    public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
        Store.Provider provider;
        ResourcePool heapPool = storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.HEAP);
        ResourcePool offHeapPool = storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.OFFHEAP);
        ResourcePool diskPool = storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.DISK);
        ArrayList enhancedServiceConfigs = new ArrayList(Arrays.asList(serviceConfigs));
        if (diskPool != null) {
            if (heapPool == null) {
                throw new IllegalArgumentException("Cannot store to disk without heap resource");
            }
            provider = (Store.Provider)this.serviceProvider.getService(CacheStore.Provider.class);
            if (offHeapPool != null) {
                enhancedServiceConfigs.add(new CompoundCachingTierServiceConfiguration().higherProvider(OnHeapStore.Provider.class).lowerProvider(OffHeapStore.Provider.class));
                enhancedServiceConfigs.add(new CacheStoreServiceConfiguration().cachingTierProvider(CompoundCachingTier.Provider.class).authoritativeTierProvider(OffHeapDiskStore.Provider.class));
            } else {
                enhancedServiceConfigs.add(new CacheStoreServiceConfiguration().cachingTierProvider(OnHeapStore.Provider.class).authoritativeTierProvider(OffHeapDiskStore.Provider.class));
            }
        } else if (offHeapPool != null) {
            if (heapPool == null) {
                throw new IllegalArgumentException("Cannot store to offheap without heap resource");
            }
            provider = (Store.Provider)this.serviceProvider.getService(CacheStore.Provider.class);
            enhancedServiceConfigs.add(new CacheStoreServiceConfiguration().cachingTierProvider(OnHeapStore.Provider.class).authoritativeTierProvider(OffHeapStore.Provider.class));
        } else {
            provider = (Store.Provider)this.serviceProvider.getService(OnHeapStore.Provider.class);
        }
        Store store = provider.createStore(storeConfig, enhancedServiceConfigs.toArray(new ServiceConfiguration[0]));
        if (this.providersMap.putIfAbsent(store, provider) != null) {
            throw new IllegalStateException("Instance of the Store already registered!");
        }
        return store;
    }

    public void releaseStore(Store<?, ?> resource) {
        Store.Provider provider = (Store.Provider)this.providersMap.get(resource);
        if (provider == null) {
            throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
        }
        provider.releaseStore(resource);
    }

    public void initStore(Store<?, ?> resource) {
        Store.Provider provider = (Store.Provider)this.providersMap.get(resource);
        if (provider == null) {
            throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
        }
        provider.initStore(resource);
    }

    public void start(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void stop() {
        this.serviceProvider = null;
        this.providersMap.clear();
    }
}

