/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.ThreadPoolsService;
import org.ehcache.util.ThreadPoolUtil;

public class DefaultThreadPoolsService
implements ThreadPoolsService {
    private volatile ScheduledExecutorService statisticsExecutor;
    private volatile ExecutorService eventsOrderedDeliveryExecutor;
    private volatile ExecutorService eventsUnorderedDeliveryExecutor;

    public ScheduledExecutorService getStatisticsExecutor() {
        if (this.statisticsExecutor == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " not started");
        }
        return this.statisticsExecutor;
    }

    public ExecutorService getEventsOrderedDeliveryExecutor() {
        if (this.eventsOrderedDeliveryExecutor == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " not started");
        }
        return this.eventsOrderedDeliveryExecutor;
    }

    public ExecutorService getEventsUnorderedDeliveryExecutor() {
        if (this.eventsUnorderedDeliveryExecutor == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " not started");
        }
        return this.eventsUnorderedDeliveryExecutor;
    }

    public void start(ServiceProvider serviceProvider) {
        this.statisticsExecutor = ThreadPoolUtil.createStatisticsExecutor();
        this.eventsOrderedDeliveryExecutor = ThreadPoolUtil.createEventsOrderedDeliveryExecutor();
        this.eventsUnorderedDeliveryExecutor = ThreadPoolUtil.createEventsUnorderedDeliveryExecutor();
    }

    public void stop() {
        this.statisticsExecutor.shutdownNow();
        this.eventsOrderedDeliveryExecutor.shutdownNow();
        this.eventsUnorderedDeliveryExecutor.shutdownNow();
    }
}

