/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.serializer;

import org.ehcache.internal.classes.ClassInstanceProviderConfiguration;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;

public class DefaultSerializationProviderConfiguration
extends ClassInstanceProviderConfiguration<Serializer<?>>
implements ServiceConfiguration<SerializationProvider> {
    public Class<SerializationProvider> getServiceType() {
        return SerializationProvider.class;
    }

    public <T> DefaultSerializationProviderConfiguration addSerializerFor(Class<T> serializableClass, Class<? extends Serializer<T>> serializerClass) {
        if (serializableClass == null) {
            throw new NullPointerException("Serializable class cannot be null");
        }
        if (serializerClass == null) {
            throw new NullPointerException("Serializer class cannot be null");
        }
        String alias = serializableClass.getName();
        if (this.getDefaults().containsKey(alias)) {
            throw new IllegalArgumentException("Duplicate serializer for class : " + alias);
        }
        this.getDefaults().put(alias, serializerClass);
        return this;
    }
}

