/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.disk;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.ehcache.function.Predicate;
import org.ehcache.function.Predicates;
import org.ehcache.internal.TimeSource;
import org.ehcache.internal.store.disk.DiskStore;
import org.ehcache.internal.store.disk.DiskValueHolder;
import org.ehcache.internal.store.disk.ElementSubstituteFilter;
import org.ehcache.internal.store.disk.Segment;
import org.ehcache.internal.store.disk.ods.FileAllocationTree;
import org.ehcache.internal.store.disk.ods.Region;
import org.ehcache.internal.store.disk.utils.ConcurrencyUtil;
import org.ehcache.spi.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskStorageFactory<K, V> {
    private static final int SHUTDOWN_GRACE_PERIOD = 60;
    private static final int MAX_EVICT = 5;
    private static final int SAMPLE_SIZE = 30;
    private static final Logger LOG = LoggerFactory.getLogger((String)DiskStorageFactory.class.getName());
    protected volatile DiskStore<K, V> store;
    private final BlockingQueue<Runnable> diskQueue;
    private final ScheduledThreadPoolExecutor diskWriter;
    private final long queueCapacity;
    private final File file;
    private final RandomAccessFile[] dataAccess;
    private final FileAllocationTree allocator;
    private volatile int elementSize;
    private final ElementSubstituteFilter onDiskFilter = new OnDiskFilter();
    private final AtomicInteger onDisk = new AtomicInteger();
    private final File indexFile;
    private final IndexWriteTask flushTask;
    private final TimeSource timeSource;
    private final Serializer<Element> elementSerializer;
    private final Serializer<Object> indexSerializer;
    private final long capacity;
    private final Predicate<DiskSubstitute<K, V>> evictionVeto;
    private final Comparator<DiskSubstitute<K, V>> evictionPrioritizer;

    public DiskStorageFactory(long capacity, Predicate<DiskSubstitute<K, V>> evictionVeto, Comparator<DiskSubstitute<K, V>> evictionPrioritizer, TimeSource timeSource, Serializer<Element> elementSerializer, Serializer<Object> indexSerializer, File dataFile, File indexFile, int stripes, long queueCapacity, int expiryThreadInterval) throws FileNotFoundException {
        this.capacity = capacity;
        this.evictionVeto = evictionVeto;
        this.evictionPrioritizer = evictionPrioritizer;
        this.timeSource = timeSource;
        this.elementSerializer = elementSerializer;
        this.indexSerializer = indexSerializer;
        this.file = dataFile;
        this.indexFile = indexFile;
        if (!dataFile.exists() || !indexFile.exists()) {
            throw new FileNotFoundException("Data file " + dataFile + " or index file " + indexFile + " missing.");
        }
        try {
            this.dataAccess = DiskStorageFactory.allocateRandomAccessFiles(this.file, stripes);
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalArgumentException(fnfe);
        }
        this.allocator = new FileAllocationTree(Long.MAX_VALUE, this.dataAccess[0]);
        this.diskWriter = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, DiskStorageFactory.this.file.getName());
                t.setDaemon(false);
                return t;
            }
        });
        this.diskQueue = this.diskWriter.getQueue();
        this.queueCapacity = queueCapacity;
        this.diskWriter.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.diskWriter.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.diskWriter.scheduleWithFixedDelay(new DiskExpiryTask(), expiryThreadInterval, expiryThreadInterval, TimeUnit.SECONDS);
        this.flushTask = new IndexWriteTask(indexFile);
    }

    private static RandomAccessFile[] allocateRandomAccessFiles(File f, int stripes) throws FileNotFoundException {
        int roundedStripes = stripes;
        while ((roundedStripes & roundedStripes - 1) != 0) {
            ++roundedStripes;
        }
        RandomAccessFile[] result = new RandomAccessFile[roundedStripes];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new RandomAccessFile(f, "rw");
        }
        return result;
    }

    private RandomAccessFile getDataAccess(Object key) {
        return this.dataAccess[ConcurrencyUtil.selectLock(key, this.dataAccess.length)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOnDiskSizeInBytes() {
        RandomAccessFile randomAccessFile = this.dataAccess[0];
        synchronized (randomAccessFile) {
            try {
                return this.dataAccess[0].length();
            }
            catch (IOException e) {
                LOG.warn("Exception trying to determine store size", (Throwable)e);
                return 0L;
            }
        }
    }

    public void bind(DiskStore<K, V> store) {
        this.store = store;
        this.loadIndex();
    }

    public void free(Lock lock, DiskSubstitute<K, V> substitute) {
        this.free(lock, substitute, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Lock lock, DiskSubstitute<K, V> substitute, boolean faultFailure) {
        if (substitute instanceof DiskMarker) {
            if (!faultFailure) {
                this.onDisk.decrementAndGet();
            }
            DiskFreeTask free = new DiskFreeTask(lock, (DiskMarker)substitute);
            if (lock.tryLock()) {
                try {
                    free.call();
                }
                finally {
                    lock.unlock();
                }
            } else {
                this.schedule(free);
            }
        }
    }

    protected void markUsed(DiskMarker<K, V> marker) {
        this.allocator.mark(new Region(((DiskMarker)marker).getPosition(), ((DiskMarker)marker).getPosition() + (long)marker.getSize() - 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shrinkDataFile() {
        RandomAccessFile randomAccessFile = this.dataAccess[0];
        synchronized (randomAccessFile) {
            try {
                this.dataAccess[0].setLength(this.allocator.getFileSize());
            }
            catch (IOException e) {
                LOG.error("Exception trying to shrink data file to size", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() throws IOException {
        this.diskWriter.shutdown();
        for (int i = 0; i < 60; ++i) {
            try {
                if (this.diskWriter.awaitTermination(1L, TimeUnit.SECONDS)) break;
                LOG.info("Waited " + (i + 1) + " seconds for shutdown of [" + this.file.getName() + "]");
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn("Received exception while waiting for shutdown", (Throwable)e);
            }
        }
        RandomAccessFile[] arr$ = this.dataAccess;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RandomAccessFile raf;
            RandomAccessFile randomAccessFile = raf = arr$[i$];
            synchronized (randomAccessFile) {
                raf.close();
                continue;
            }
        }
    }

    protected <U> Future<U> schedule(Callable<U> call) {
        return this.diskWriter.submit(call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element<K, V> read(DiskMarker<K, V> marker) throws IOException, ClassNotFoundException {
        RandomAccessFile data;
        byte[] buffer = new byte[marker.getSize()];
        RandomAccessFile randomAccessFile = data = this.getDataAccess(marker.getKey());
        synchronized (randomAccessFile) {
            data.seek(((DiskMarker)marker).getPosition());
            data.readFully(buffer);
        }
        return (Element)this.elementSerializer.read(ByteBuffer.wrap(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiskMarker<K, V> write(Element<K, V> element) throws IOException {
        RandomAccessFile data;
        int bufferLength;
        ByteBuffer buffer = this.serializeElement(element);
        this.elementSize = bufferLength = buffer.remaining();
        DiskMarker<K, V> marker = this.alloc(element, bufferLength);
        RandomAccessFile randomAccessFile = data = this.getDataAccess(element.getKey());
        synchronized (randomAccessFile) {
            data.seek(((DiskMarker)marker).getPosition());
            byte[] bytes = new byte[bufferLength];
            buffer.get(bytes);
            data.write(bytes, 0, bufferLength);
        }
        return marker;
    }

    private ByteBuffer serializeElement(Element<K, V> element) throws IOException {
        try {
            return this.elementSerializer.serialize(element);
        }
        catch (ConcurrentModificationException e) {
            throw new RuntimeException("Failed to serialize element due to ConcurrentModificationException. This is frequently the result of inappropriately sharing thread unsafe object (eg. ArrayList, HashMap, etc) between threads", e);
        }
    }

    private DiskMarker<K, V> alloc(Element<K, V> element, int size) throws IOException {
        Region r = this.allocator.alloc(size);
        return this.createMarker(r.start(), size, element);
    }

    protected void free(DiskMarker<K, V> marker) {
        this.allocator.free(new Region(((DiskMarker)marker).getPosition(), ((DiskMarker)marker).getPosition() + (long)marker.getSize() - 1L));
    }

    public boolean bufferFull() {
        return (long)(this.diskQueue.size() * this.elementSize) > this.queueCapacity;
    }

    public void expireElements() {
        new DiskExpiryTask().run();
    }

    public DiskSubstitute<K, V> create(Element<K, V> element) throws IllegalArgumentException {
        return new Placeholder<K, V>(element, this);
    }

    public Element<K, V> retrieve(DiskSubstitute<K, V> object) {
        if (object instanceof DiskMarker) {
            try {
                DiskMarker marker = (DiskMarker)object;
                Element<K, V> read = this.read(marker);
                read.getValueHolder().setExpireTimeMillis(((DiskMarker)object).expiry);
                return read;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (object instanceof Placeholder) {
            return ((Placeholder)object).getElement();
        }
        return null;
    }

    public Element<K, V> retrieve(DiskSubstitute<K, V> object, Segment<K, V> segment) {
        if (object instanceof DiskMarker) {
            try {
                DiskMarker marker = (DiskMarker)object;
                Element<K, V> e = this.read(marker);
                marker.hit(e);
                return e;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (object instanceof Placeholder) {
            return ((Placeholder)object).getElement();
        }
        return null;
    }

    public boolean created(Object object) {
        if (object instanceof DiskSubstitute) {
            return ((DiskSubstitute)object).getFactory() == this;
        }
        return false;
    }

    public void unbind() {
        try {
            this.flush().get();
        }
        catch (Throwable t) {
            LOG.error("Could not flush disk cache. Initial cause was " + t.getMessage(), t);
        }
        try {
            this.shutdown();
        }
        catch (IOException e) {
            LOG.error("Could not shut down disk cache. Initial cause was " + e.getMessage(), (Throwable)e);
        }
    }

    public Future<Void> flush() {
        return this.schedule(this.flushTask);
    }

    private DiskMarker<K, V> createMarker(long position, int size, Element<K, V> element) {
        return new DiskMarker<K, V>(this, position, size, element);
    }

    int evict(int count) {
        int evicted = 0;
        for (int i = 0; i < count; ++i) {
            Element<Object, V> evictedElement;
            DiskSubstitute<Object, V> target = this.getDiskEvictionTarget(null, count, this.evictionVeto);
            if (target == null) {
                target = this.getDiskEvictionTarget(null, count, Predicates.none());
            }
            if (target == null || (evictedElement = this.store.evict(target.getKey(), null)) == null) continue;
            ++evicted;
        }
        return evicted;
    }

    public int getOnDiskSize() {
        return this.onDisk.get();
    }

    void evictToSize() {
        this.onDiskEvict(this.onDisk.get(), null);
    }

    private void onDiskEvict(int size, K keyHint) {
        long diskCapacity = this.capacity;
        if (diskCapacity > 0L) {
            long delta = (long)size - diskCapacity;
            int overflow = delta <= 0L ? 0 : (int)delta;
            for (int i = 0; i < Math.min(5, overflow); ++i) {
                Element<K, V> element;
                DiskSubstitute<K, V> target = this.getDiskEvictionTarget(keyHint, size, this.evictionVeto);
                if (target == null) {
                    target = this.getDiskEvictionTarget(keyHint, size, Predicates.none());
                }
                if (target != null && (element = this.store.evict(target.getKey(), target)) != null && (long)this.onDisk.get() <= diskCapacity) break;
            }
        }
    }

    private DiskSubstitute<K, V> getDiskEvictionTarget(K keyHint, int size, Predicate<DiskSubstitute<K, V>> evictionVeto) {
        List<DiskSubstitute<K, V>> sample = this.store.getRandomSample(this.onDiskFilter, Math.min(30, size), keyHint);
        DiskSubstitute<K, V> target = null;
        DiskSubstitute<K, V> hintTarget = null;
        Collections.sort(sample, this.evictionPrioritizer);
        for (DiskSubstitute<K, V> substitute : sample) {
            if (evictionVeto.test(substitute) || target != null && !(substitute.getHitRate() < target.getHitRate())) continue;
            if (substitute.getKey().equals(keyHint)) {
                hintTarget = substitute;
                continue;
            }
            target = substitute;
        }
        return target != null ? target : hintTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void loadIndex() {
        block15: {
            if (!this.indexFile.exists()) {
                return;
            }
            try {
                readableByteChannel = Channels.newChannel(new FileInputStream(this.indexFile));
                marker = this.readMarker(readableByteChannel);
                while (true) {
                    marker.bindFactory(this);
                    this.markUsed(marker);
                    if (!this.store.putRawIfAbsent(marker.getKey(), marker)) ** break block13
                    this.onDisk.incrementAndGet();
                    break block14;
                    break;
                }
                {
                    catch (Throwable var3_5) {
                        readableByteChannel.close();
                        throw var3_5;
                    }
                }
                {
                    block14: {
                        readableByteChannel.close();
                        return;
                    }
                    marker = this.readMarker(readableByteChannel);
                    continue;
                }
                catch (EOFException e) {
                    break block15;
                }
                catch (Exception e) {
                    DiskStorageFactory.LOG.warn("Index file {} is corrupt, deleting and ignoring it : {}", (Object)this.indexFile, (Object)e);
                    DiskStorageFactory.LOG.debug("Corrupt index file {} error :", (Object)this.indexFile, (Object)e);
                    this.store.internalClear();
                }
            }
            finally {
                this.shrinkDataFile();
            }
        }
    }

    private DiskMarker<K, V> readMarker(ReadableByteChannel readableByteChannel) throws IOException, ClassNotFoundException {
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
        sizeBuffer.clear();
        int read = readableByteChannel.read(sizeBuffer);
        if (read == -1) {
            throw new EOFException();
        }
        sizeBuffer.rewind();
        ByteBuffer valueBuffer = ByteBuffer.allocate(sizeBuffer.getInt());
        read = readableByteChannel.read(valueBuffer);
        if (read == -1) {
            throw new EOFException();
        }
        valueBuffer.rewind();
        return (DiskMarker)this.indexSerializer.read(valueBuffer);
    }

    class IndexWriteTask
    implements Callable<Void> {
        private final File index;

        IndexWriteTask(File index) {
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Void call() throws IOException, InterruptedException {
            WritableByteChannel writableByteChannel = Channels.newChannel(new FileOutputStream(this.index));
            try {
                Iterator diskSubstituteIterator = DiskStorageFactory.this.store.diskSubstituteIterator();
                while (diskSubstituteIterator.hasNext()) {
                    DiskSubstitute o = diskSubstituteIterator.next();
                    Object key = o.getKey();
                    if (o instanceof Placeholder && !((Placeholder)o).failedToFlush && (o = new PersistentDiskWriteTask((Placeholder)o, DiskStorageFactory.this).call()) == null) {
                        o = DiskStorageFactory.this.store.unretrievedGet(key);
                    }
                    if (!(o instanceof DiskMarker)) continue;
                    DiskMarker marker = (DiskMarker)o;
                    this.writeMarker(writableByteChannel, marker);
                }
            }
            finally {
                writableByteChannel.close();
            }
            return null;
        }

        private void writeMarker(WritableByteChannel writableByteChannel, DiskMarker<K, V> marker) throws IOException {
            ByteBuffer markerBuffer = DiskStorageFactory.this.indexSerializer.serialize(marker);
            ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
            sizeBuffer.clear();
            sizeBuffer.putInt(markerBuffer.limit());
            sizeBuffer.rewind();
            writableByteChannel.write(sizeBuffer);
            writableByteChannel.write(markerBuffer);
        }
    }

    private static final class PersistentDiskWriteTask<K, V>
    extends DiskWriteTask<K, V> {
        PersistentDiskWriteTask(Placeholder<K, V> p, DiskStorageFactory<K, V> storageFactory) {
            super(p, storageFactory);
        }

        @Override
        public DiskMarker<K, V> call() {
            Object result = super.call();
            if (result != null) {
                int disk = ((DiskWriteTask)this).storageFactory.onDisk.incrementAndGet();
                ((DiskWriteTask)this).storageFactory.onDiskEvict(disk, this.getPlaceholder().getKey());
            }
            return result;
        }
    }

    private class OnDiskFilter
    implements ElementSubstituteFilter {
        private OnDiskFilter() {
        }

        @Override
        public boolean allows(Object object) {
            if (!DiskStorageFactory.this.created(object)) {
                return false;
            }
            return object instanceof DiskMarker;
        }
    }

    private final class DiskExpiryTask
    implements Runnable {
        private DiskExpiryTask() {
        }

        @Override
        public void run() {
            long now = DiskStorageFactory.this.timeSource.getTimeMillis();
            Iterator diskSubstituteIterator = DiskStorageFactory.this.store.diskSubstituteIterator();
            while (diskSubstituteIterator.hasNext()) {
                DiskSubstitute value = diskSubstituteIterator.next();
                if (!DiskStorageFactory.this.created(value) || !(value instanceof DiskMarker)) continue;
                this.checkExpiry((DiskMarker)value, now);
            }
        }

        private void checkExpiry(DiskMarker<K, V> marker, long now) {
            if (marker.getExpirationTime() < now) {
                DiskStorageFactory.this.store.expire(marker.getKey(), marker);
            }
        }
    }

    public static class DiskMarker<K, V>
    extends DiskSubstitute<K, V>
    implements Serializable {
        private final K key;
        private final long position;
        private final int size;
        private volatile float hitRate;
        private volatile long expiry;

        DiskMarker(DiskStorageFactory<K, V> factory, long position, int size, Element<K, V> element) {
            super(factory);
            this.position = position;
            this.size = size;
            this.key = element.getKey();
            this.hitRate = element.getValueHolder().hitRate(TimeUnit.SECONDS);
            this.expiry = element.getValueHolder().getExpireTimeMillis();
        }

        DiskMarker(DiskStorageFactory<K, V> factory, long position, int size, K key, long hits) {
            super(factory);
            this.position = position;
            this.size = size;
            this.key = key;
            this.hitRate = hits;
        }

        @Override
        K getKey() {
            return this.key;
        }

        @Override
        float getHitRate() {
            return this.hitRate;
        }

        private long getPosition() {
            return this.position;
        }

        public int getSize() {
            return this.size;
        }

        @Override
        public void installed() {
        }

        @Override
        public long getExpirationTime() {
            return this.expiry;
        }

        void hit(Element<K, V> e) {
            this.hitRate += 1.0f;
            this.expiry = e.getValueHolder().getExpireTimeMillis();
        }

        void updateStats(float hitRate, long expireTimeMillis) {
            this.hitRate = hitRate;
            this.expiry = expireTimeMillis;
        }
    }

    static final class Placeholder<K, V>
    extends DiskSubstitute<K, V> {
        private final K key;
        private final Element<K, V> element;
        private volatile boolean failedToFlush;

        Placeholder(Element<K, V> element, DiskStorageFactory<K, V> factory) {
            super(factory);
            this.key = element.getKey();
            this.element = element;
        }

        boolean hasFailedToFlush() {
            return this.failedToFlush;
        }

        private void setFailedToFlush(boolean failedToFlush) {
            this.failedToFlush = failedToFlush;
        }

        @Override
        public void installed() {
            this.getFactory().schedule(new PersistentDiskWriteTask(this, ((DiskSubstitute)this).factory));
        }

        @Override
        K getKey() {
            return this.key;
        }

        @Override
        float getHitRate() {
            return this.getElement().getValueHolder().hitRate(TimeUnit.SECONDS);
        }

        @Override
        long getExpirationTime() {
            return this.getElement().getValueHolder().getExpireTimeMillis();
        }

        Element<K, V> getElement() {
            return this.element;
        }
    }

    public static abstract class DiskSubstitute<K, V> {
        private volatile transient DiskStorageFactory<K, V> factory;

        public DiskSubstitute() {
            this.factory = null;
        }

        DiskSubstitute(DiskStorageFactory<K, V> factory) {
            this.factory = factory;
        }

        abstract K getKey();

        abstract float getHitRate();

        abstract long getExpirationTime();

        abstract void installed();

        public final DiskStorageFactory<K, V> getFactory() {
            return this.factory;
        }

        void bindFactory(DiskStorageFactory<K, V> factory) {
            this.factory = factory;
        }
    }

    private final class DiskFreeTask
    implements Callable<Void> {
        private final Lock lock;
        private final DiskMarker<K, V> marker;

        private DiskFreeTask(Lock lock, DiskMarker<K, V> marker) {
            this.lock = lock;
            this.marker = marker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            this.lock.lock();
            try {
                DiskStorageFactory.this.free(this.marker);
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }
    }

    static abstract class DiskWriteTask<K, V>
    implements Callable<DiskMarker<K, V>> {
        private final Placeholder<K, V> placeholder;
        private final DiskStorageFactory<K, V> storageFactory;

        DiskWriteTask(Placeholder<K, V> p, DiskStorageFactory<K, V> storageFactory) {
            this.placeholder = p;
            this.storageFactory = storageFactory;
        }

        Placeholder<K, V> getPlaceholder() {
            return this.placeholder;
        }

        @Override
        public DiskMarker<K, V> call() {
            try {
                if (this.storageFactory.store.containsKey(this.placeholder.getKey())) {
                    DiskMarker<K, V> marker = this.storageFactory.write(this.placeholder.getElement());
                    if (marker != null && this.storageFactory.store.fault(this.placeholder.getKey(), this.placeholder, marker)) {
                        return marker;
                    }
                    return null;
                }
                return null;
            }
            catch (Throwable e) {
                LOG.error("Disk Write of " + this.placeholder.getKey() + " failed: ", e);
                this.storageFactory.store.evict(this.placeholder.getKey(), this.placeholder);
                return null;
            }
        }
    }

    static class DiskValueHolderImpl<V>
    implements DiskValueHolder<V>,
    Serializable {
        private static final long serialVersionUID = -7234449795271393813L;
        static final long NO_EXPIRE = -1L;
        private final V value;
        private final long createTime;
        private volatile long accessTime;
        private volatile long expireTime;

        public DiskValueHolderImpl(V value, long createTime, long expireTime) {
            this.value = value;
            this.createTime = createTime;
            this.setExpireTimeMillis(expireTime);
        }

        @Override
        public void setAccessTimeMillis(long accessTime) {
            this.accessTime = accessTime;
        }

        @Override
        public void setExpireTimeMillis(long expireTime) {
            if (expireTime <= 0L && expireTime != -1L) {
                throw new IllegalArgumentException("invalid expire time: " + expireTime);
            }
            this.expireTime = expireTime;
        }

        @Override
        public boolean isExpired(long now) {
            long expire = this.expireTime;
            if (expire == -1L) {
                return false;
            }
            return expire <= now;
        }

        @Override
        public long getExpireTimeMillis() {
            return this.expireTime;
        }

        public V value() {
            return this.value;
        }

        public long creationTime(TimeUnit unit) {
            return TimeUnit.MILLISECONDS.convert(this.createTime, unit);
        }

        public long lastAccessTime(TimeUnit unit) {
            return TimeUnit.MILLISECONDS.convert(this.accessTime, unit);
        }

        public float hitRate(TimeUnit unit) {
            return 0.0f;
        }

        public String toString() {
            return "" + this.value;
        }
    }

    static class ElementImpl<K, V>
    implements Element<K, V> {
        private static final long serialVersionUID = -7234449795271393813L;
        private final DiskValueHolder<V> valueHolder;
        private final K key;
        private transient boolean faulted;

        public ElementImpl(K key, V value, long createTime, long expireTime) {
            this.key = key;
            this.valueHolder = new DiskValueHolderImpl<V>(value, createTime, expireTime);
        }

        @Override
        public boolean isExpired(long time) {
            return !this.faulted && this.valueHolder.isExpired(time);
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public DiskValueHolder<V> getValueHolder() {
            return this.valueHolder;
        }

        @Override
        public void setFaulted(boolean faulted) {
            this.faulted = faulted;
        }

        @Override
        public boolean isFaulted() {
            return this.faulted;
        }
    }

    public static interface Element<K, V>
    extends Serializable {
        public boolean isExpired(long var1);

        public K getKey();

        public DiskValueHolder<V> getValueHolder();

        public void setFaulted(boolean var1);

        public boolean isFaulted();
    }
}

