/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store;

import java.util.ArrayList;
import java.util.Arrays;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.internal.store.disk.DiskStore;
import org.ehcache.internal.store.heap.OnHeapStore;
import org.ehcache.internal.store.offheap.OffHeapStore;
import org.ehcache.internal.store.tiering.CacheStore;
import org.ehcache.internal.store.tiering.CacheStoreServiceConfig;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.service.ServiceConfiguration;

public class DefaultStoreProvider
implements Store.Provider {
    private ServiceProvider serviceProvider;

    public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
        Store.Provider provider;
        ResourcePool heapPool = storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.HEAP);
        ResourcePool offHeapPool = storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.OFFHEAP);
        ResourcePool diskPool = storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.DISK);
        ArrayList enhancedServiceConfigs = new ArrayList(Arrays.asList(serviceConfigs));
        if (diskPool != null) {
            if (offHeapPool != null) {
                throw new IllegalArgumentException("Cannot combine offheap and disk stores");
            }
            if (heapPool == null) {
                throw new IllegalArgumentException("Cannot store to disk without heap resource");
            }
            provider = (Store.Provider)this.serviceProvider.findService(CacheStore.Provider.class);
            enhancedServiceConfigs.add(new CacheStoreServiceConfig().cachingTierProvider(OnHeapStore.Provider.class).authoritativeTierProvider(DiskStore.Provider.class));
        } else if (offHeapPool != null) {
            if (heapPool == null) {
                throw new IllegalArgumentException("Cannot store to offheap without heap resource");
            }
            provider = (Store.Provider)this.serviceProvider.findService(CacheStore.Provider.class);
            enhancedServiceConfigs.add(new CacheStoreServiceConfig().cachingTierProvider(OnHeapStore.Provider.class).authoritativeTierProvider(OffHeapStore.Provider.class));
        } else {
            provider = (Store.Provider)this.serviceProvider.findService(OnHeapStore.Provider.class);
        }
        return provider.createStore(storeConfig, enhancedServiceConfigs.toArray(new ServiceConfiguration[0]));
    }

    public void releaseStore(Store<?, ?> resource) {
        resource.close();
    }

    public void start(ServiceConfiguration<?> config, ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void stop() {
    }
}

