/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.internal.util.ByteBufferInputStream;
import org.ehcache.spi.serialization.Serializer;

public class JavaSerializer<T>
implements Serializer<T> {
    private final ClassLoader classLoader;

    public JavaSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer serialize(T object) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(object);
        }
        finally {
            bout.close();
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read(ByteBuffer entry) throws IOException, ClassNotFoundException {
        ByteBufferInputStream bin = null;
        try {
            Object object;
            bin = new ByteBufferInputStream(entry);
            OIS ois = new OIS(bin, this.classLoader);
            try {
                object = ois.readObject();
            }
            catch (Throwable throwable) {
                ois.close();
                throw throwable;
            }
            ois.close();
            return (T)object;
        }
        finally {
            if (bin != null) {
                bin.close();
            }
        }
    }

    public boolean equals(T object, ByteBuffer binary) throws IOException, ClassNotFoundException {
        return object.equals(this.read(binary));
    }

    private static class OIS
    extends ObjectInputStream {
        private final ClassLoader classLoader;
        private static final Map<String, Class<?>> primitiveClasses = new HashMap();

        public OIS(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(desc.getName(), false, this.classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                Class<?> primitive = primitiveClasses.get(desc.getName());
                if (primitive != null) {
                    return primitive;
                }
                throw cnfe;
            }
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            Class[] interfaceClasses = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                interfaceClasses[i] = Class.forName(interfaces[i], false, this.classLoader);
            }
            return Proxy.getProxyClass(this.classLoader, interfaceClasses);
        }

        static {
            primitiveClasses.put("boolean", Boolean.TYPE);
            primitiveClasses.put("byte", Byte.TYPE);
            primitiveClasses.put("char", Character.TYPE);
            primitiveClasses.put("double", Double.TYPE);
            primitiveClasses.put("float", Float.TYPE);
            primitiveClasses.put("int", Integer.TYPE);
            primitiveClasses.put("long", Long.TYPE);
            primitiveClasses.put("short", Short.TYPE);
            primitiveClasses.put("void", Void.TYPE);
        }
    }
}

