/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.net.URI;
import java.util.EnumSet;
import javax.cache.management.CacheStatisticsMXBean;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.jsr107.Eh107MXBean;
import org.terracotta.statistics.derived.latency.Jsr107LatencyMonitor;
import org.terracotta.statistics.observer.ChainedOperationObserver;

class Eh107CacheStatisticsMXBean
extends Eh107MXBean
implements CacheStatisticsMXBean {
    private final CacheStatistics cacheStatistics;
    private final Jsr107LatencyMonitor<CacheOperationOutcomes.GetOutcome> averageGetTime;
    private final Jsr107LatencyMonitor<CacheOperationOutcomes.PutOutcome> averagePutTime;
    private final Jsr107LatencyMonitor<CacheOperationOutcomes.RemoveOutcome> averageRemoveTime;

    Eh107CacheStatisticsMXBean(String cacheName, URI cacheManagerURI, StatisticsService statisticsService) {
        super(cacheName, cacheManagerURI, "CacheStatistics");
        this.cacheStatistics = statisticsService.getCacheStatistics(cacheName);
        this.averageGetTime = this.registerDerivedStatistics(CacheOperationOutcomes.GetOutcome.class, "get");
        this.averagePutTime = this.registerDerivedStatistics(CacheOperationOutcomes.PutOutcome.class, "put");
        this.averageRemoveTime = this.registerDerivedStatistics(CacheOperationOutcomes.RemoveOutcome.class, "remove");
    }

    private <T extends Enum<T>> Jsr107LatencyMonitor<T> registerDerivedStatistics(Class<T> outcome, String name) {
        Jsr107LatencyMonitor monitor = new Jsr107LatencyMonitor(EnumSet.allOf(outcome), 1.0);
        CacheStatistics cacheStatistics = this.cacheStatistics;
        cacheStatistics.registerDerivedStatistic(outcome, name, (ChainedOperationObserver)monitor);
        return monitor;
    }

    public void clear() {
        this.cacheStatistics.clear();
        this.averageGetTime.clear();
        this.averagePutTime.clear();
        this.averageRemoveTime.clear();
    }

    public long getCacheHits() {
        return this.cacheStatistics.getCacheHits();
    }

    public float getCacheHitPercentage() {
        return this.cacheStatistics.getCacheHitPercentage();
    }

    public long getCacheMisses() {
        return this.cacheStatistics.getCacheMisses();
    }

    public float getCacheMissPercentage() {
        return this.cacheStatistics.getCacheMissPercentage();
    }

    public long getCacheGets() {
        return this.cacheStatistics.getCacheGets();
    }

    public long getCachePuts() {
        return this.cacheStatistics.getCachePuts();
    }

    public long getCacheRemovals() {
        return this.cacheStatistics.getCacheRemovals();
    }

    public long getCacheEvictions() {
        return this.cacheStatistics.getCacheEvictions();
    }

    public float getAverageGetTime() {
        return (float)this.averageGetTime.average();
    }

    public float getAveragePutTime() {
        return (float)this.averagePutTime.average();
    }

    public float getAverageRemoveTime() {
        return (float)this.averageRemoveTime.average();
    }
}

