/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107.internal;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.jsr107.config.ConfigurationElementState;
import org.ehcache.jsr107.config.Jsr107Configuration;
import org.ehcache.jsr107.config.Jsr107Service;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.BaseConfigParser;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Jsr107ServiceConfigurationParser
extends BaseConfigParser<Jsr107Configuration>
implements CacheManagerServiceConfigurationParser<Jsr107Service> {
    private static final URI NAMESPACE = URI.create("http://www.ehcache.org/v3/jsr107");
    private static final URL XML_SCHEMA = Jsr107ServiceConfigurationParser.class.getResource("/ehcache-107ext.xsd");
    private static final String ENABLE_MANAGEMENT_ALL_ATTRIBUTE = "enable-management";
    private static final String JSR_107_COMPLIANT_ATOMICS_ATTRIBUTE = "jsr-107-compliant-atomics";
    private static final String ENABLE_STATISTICS_ALL_ATTRIBUTE = "enable-statistics";
    private static final String DEFAULT_TEMPLATE_ATTRIBUTE = "default-template";
    private static final String CACHE_NAME_ATTRIBUTE = "name";
    private static final String TEMPLATE_NAME_ATTRIBUTE = "template";
    private static final String DEFAULT_ELEMENT_NAME = "defaults";
    public static final String JSR_NAMESPACE_PREFIX = "jsr107";
    private static final String CACHE_ELEMENT_NAME = "cache";

    public Source getXmlSchema() throws IOException {
        return new StreamSource(XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return NAMESPACE;
    }

    public ServiceCreationConfiguration<Jsr107Service> parseServiceCreationConfiguration(Element fragment) {
        boolean jsr107CompliantAtomics = true;
        ConfigurationElementState enableManagementAll = ConfigurationElementState.UNSPECIFIED;
        ConfigurationElementState enableStatisticsAll = ConfigurationElementState.UNSPECIFIED;
        if (fragment.hasAttribute(JSR_107_COMPLIANT_ATOMICS_ATTRIBUTE)) {
            jsr107CompliantAtomics = Boolean.parseBoolean(fragment.getAttribute(JSR_107_COMPLIANT_ATOMICS_ATTRIBUTE));
        }
        if (fragment.hasAttribute(ENABLE_MANAGEMENT_ALL_ATTRIBUTE)) {
            ConfigurationElementState configurationElementState = enableManagementAll = Boolean.parseBoolean(fragment.getAttribute(ENABLE_MANAGEMENT_ALL_ATTRIBUTE)) ? ConfigurationElementState.ENABLED : ConfigurationElementState.DISABLED;
        }
        if (fragment.hasAttribute(ENABLE_STATISTICS_ALL_ATTRIBUTE)) {
            enableStatisticsAll = Boolean.parseBoolean(fragment.getAttribute(ENABLE_STATISTICS_ALL_ATTRIBUTE)) ? ConfigurationElementState.ENABLED : ConfigurationElementState.DISABLED;
        }
        String defaultTemplate = fragment.getAttribute(DEFAULT_TEMPLATE_ATTRIBUTE);
        HashMap<String, String> templates = new HashMap<String, String>();
        NodeList childNodes = fragment.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element item = (Element)node;
            templates.put(item.getAttribute(CACHE_NAME_ATTRIBUTE), item.getAttribute(TEMPLATE_NAME_ATTRIBUTE));
        }
        return new Jsr107Configuration(defaultTemplate, templates, jsr107CompliantAtomics, enableManagementAll, enableStatisticsAll);
    }

    public Class<Jsr107Service> getServiceType() {
        return Jsr107Service.class;
    }

    public Element unparseServiceCreationConfiguration(ServiceCreationConfiguration<Jsr107Service> serviceCreationConfiguration) {
        return this.unparseConfig(serviceCreationConfiguration);
    }

    protected Element createRootElement(Document doc, Jsr107Configuration configuration) {
        Element rootElement = doc.createElementNS(NAMESPACE.toString(), "jsr107:defaults");
        rootElement.setAttribute(JSR_107_COMPLIANT_ATOMICS_ATTRIBUTE, String.valueOf(configuration.isJsr107CompliantAtomics()));
        ConfigurationElementState managementState = configuration.isEnableManagementAll();
        ConfigurationElementState statisticsState = configuration.isEnableStatisticsAll();
        if (ConfigurationElementState.ENABLED == managementState || ConfigurationElementState.DISABLED == managementState) {
            rootElement.setAttribute(ENABLE_MANAGEMENT_ALL_ATTRIBUTE, String.valueOf(managementState.asBoolean()));
        }
        if (ConfigurationElementState.ENABLED == statisticsState || ConfigurationElementState.DISABLED == statisticsState) {
            rootElement.setAttribute(ENABLE_STATISTICS_ALL_ATTRIBUTE, String.valueOf(statisticsState.asBoolean()));
        }
        if (configuration.getDefaultTemplate() != null) {
            rootElement.setAttribute(DEFAULT_TEMPLATE_ATTRIBUTE, configuration.getDefaultTemplate());
        }
        this.processCaches(doc, rootElement, configuration);
        return rootElement;
    }

    private void processCaches(Document doc, Element parent, Jsr107Configuration configuration) {
        Map<String, String> cacheMap = configuration.getTemplates();
        cacheMap.forEach((k, v) -> {
            Element cacheElement = doc.createElement("jsr107:cache");
            cacheElement.setAttribute(CACHE_NAME_ATTRIBUTE, (String)k);
            cacheElement.setAttribute(TEMPLATE_NAME_ATTRIBUTE, (String)v);
            parent.appendChild(cacheElement);
        });
    }
}

