/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import org.ehcache.jsr107.CacheResources;
import org.ehcache.jsr107.EventListenerAdaptors;
import org.ehcache.jsr107.MultiCacheException;
import org.ehcache.jsr107.NullCacheEntryEventFilter;

class ListenerResources<K, V>
implements Closeable {
    private final CacheEntryListener<? super K, ? super V> listener;
    private final CacheEntryEventFilter<? super K, ? super V> filter;
    private List<EventListenerAdaptors.EventListenerAdaptor<K, V>> ehListeners = null;

    static <K, V> ListenerResources<K, V> createListenerResources(CacheEntryListenerConfiguration<K, V> listenerConfig, MultiCacheException mce) {
        CacheEntryEventFilter filter;
        CacheEntryListener listener = (CacheEntryListener)listenerConfig.getCacheEntryListenerFactory().create();
        try {
            Factory filterFactory = listenerConfig.getCacheEntryEventFilterFactory();
            filter = filterFactory != null ? (CacheEntryEventFilter)listenerConfig.getCacheEntryEventFilterFactory().create() : NullCacheEntryEventFilter.INSTANCE;
        }
        catch (Throwable t) {
            mce.addThrowable(t);
            CacheResources.close(listener, mce);
            throw mce;
        }
        try {
            return new ListenerResources<K, V>(listener, filter);
        }
        catch (Throwable t) {
            mce.addThrowable(t);
            CacheResources.close(filter, mce);
            CacheResources.close(listener, mce);
            throw mce;
        }
    }

    ListenerResources(CacheEntryListener<? super K, ? super V> listener, CacheEntryEventFilter<? super K, ? super V> filter) {
        this.listener = listener;
        this.filter = filter;
    }

    CacheEntryEventFilter<? super K, ? super V> getFilter() {
        return this.filter;
    }

    CacheEntryListener<? super K, ? super V> getListener() {
        return this.listener;
    }

    synchronized List<EventListenerAdaptors.EventListenerAdaptor<K, V>> getEhcacheListeners(Cache<K, V> source, boolean requestsOld) {
        if (this.ehListeners == null) {
            this.ehListeners = EventListenerAdaptors.ehListenersFor(this.listener, this.filter, source, requestsOld);
        }
        return Collections.unmodifiableList(this.ehListeners);
    }

    @Override
    public void close() {
        MultiCacheException mce = new MultiCacheException();
        CacheResources.close(this.listener, mce);
        CacheResources.close(this.filter, mce);
        mce.throwIfNotEmpty();
    }
}

