/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.spi.CachingProvider;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import org.ehcache.Cache;
import org.ehcache.Ehcache;
import org.ehcache.EhcacheHackAccessor;
import org.ehcache.EhcacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.internal.store.heap.service.OnHeapStoreServiceConfiguration;
import org.ehcache.jsr107.CacheResources;
import org.ehcache.jsr107.ConfigurationMerger;
import org.ehcache.jsr107.Eh107Cache;
import org.ehcache.jsr107.Eh107CacheLoaderWriterProvider;
import org.ehcache.jsr107.Eh107CompleteConfiguration;
import org.ehcache.jsr107.Eh107Configuration;
import org.ehcache.jsr107.Eh107MXBean;
import org.ehcache.jsr107.Eh107ReverseConfiguration;
import org.ehcache.jsr107.EhcacheCachingProvider;
import org.ehcache.jsr107.EhcacheExpiryWrapper;
import org.ehcache.jsr107.Jsr107Service;
import org.ehcache.jsr107.MultiCacheException;
import org.ehcache.jsr107.Unwrap;
import org.ehcache.management.ManagementRegistry;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Eh107CacheManager
implements CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(Eh107CacheManager.class);
    private static MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private final Object cachesLock = new Object();
    private final ConcurrentMap<String, Eh107Cache<?, ?>> caches = new ConcurrentHashMap();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final EhcacheManager ehCacheManager;
    private final EhcacheCachingProvider cachingProvider;
    private final ClassLoader classLoader;
    private final URI uri;
    private final Properties props;
    private final Configuration ehConfig;
    private final ManagementRegistry managementRegistry;
    private final ConfigurationMerger configurationMerger;

    Eh107CacheManager(EhcacheCachingProvider cachingProvider, EhcacheManager ehCacheManager, Properties props, ClassLoader classLoader, URI uri, Eh107CacheLoaderWriterProvider cacheLoaderWriterFactory, Configuration ehConfig, Jsr107Service jsr107Service, ManagementRegistry managementRegistry) {
        this.cachingProvider = cachingProvider;
        this.ehCacheManager = ehCacheManager;
        this.props = props;
        this.classLoader = classLoader;
        this.uri = uri;
        this.ehConfig = ehConfig;
        this.managementRegistry = managementRegistry;
        this.configurationMerger = new ConfigurationMerger(ehConfig, jsr107Service, cacheLoaderWriterFactory, LOG);
        this.loadExistingEhcaches();
    }

    EhcacheManager getEhCacheManager() {
        return this.ehCacheManager;
    }

    private void loadExistingEhcaches() {
        for (Map.Entry entry : this.ehConfig.getCacheConfigurations().entrySet()) {
            String name = (String)entry.getKey();
            CacheConfiguration config = (CacheConfiguration)entry.getValue();
            this.caches.put(name, this.wrapEhcacheCache(name, config));
        }
    }

    private <K, V> Eh107Cache<K, V> wrapEhcacheCache(String alias, CacheConfiguration<K, V> ehConfig) {
        Cache cache = this.ehCacheManager.getCache(alias, ehConfig.getKeyType(), ehConfig.getValueType());
        return this.wrapEhcacheCache(alias, cache);
    }

    private <K, V> Eh107Cache<K, V> wrapEhcacheCache(String alias, Cache<K, V> cache) {
        CacheLoaderWriter cacheLoaderWriter = EhcacheHackAccessor.getCacheLoaderWriter((Ehcache)cache);
        boolean storeByValueOnHeap = false;
        for (ServiceConfiguration serviceConfiguration : cache.getRuntimeConfiguration().getServiceConfigurations()) {
            if (!(serviceConfiguration instanceof OnHeapStoreServiceConfiguration)) continue;
            OnHeapStoreServiceConfiguration onHeapStoreServiceConfig = (OnHeapStoreServiceConfiguration)serviceConfiguration;
            storeByValueOnHeap = onHeapStoreServiceConfig.storeByValue();
        }
        Eh107ReverseConfiguration<K, V> config = new Eh107ReverseConfiguration<K, V>(cache, cacheLoaderWriter != null, cacheLoaderWriter != null, storeByValueOnHeap);
        EhcacheExpiryWrapper expiry = new EhcacheExpiryWrapper(cache.getRuntimeConfiguration().getExpiry());
        CacheResources resources = new CacheResources(alias, cacheLoaderWriter, expiry);
        return new Eh107Cache<K, V>(alias, config, resources, cache, this, this.managementRegistry);
    }

    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Properties getProperties() {
        return new Properties(this.props);
    }

    public <K, V, C extends javax.cache.configuration.Configuration<K, V>> javax.cache.Cache<K, V> createCache(String cacheName, C config) throws IllegalArgumentException {
        Object object = this.cachesLock;
        synchronized (object) {
            Cache ehCache;
            this.checkClosed();
            if (cacheName == null || config == null) {
                throw new NullPointerException();
            }
            if (this.caches.containsKey(cacheName)) {
                throw new CacheException("A Cache named [" + cacheName + "] already exists");
            }
            if (config instanceof Eh107Configuration.Eh107ConfigurationWrapper) {
                Eh107Configuration.Eh107ConfigurationWrapper configurationWrapper = (Eh107Configuration.Eh107ConfigurationWrapper)config;
                CacheConfiguration unwrap = configurationWrapper.getCacheConfiguration();
                Eh107Cache<K, V> cache = this.wrapEhcacheCache(cacheName, this.ehCacheManager.createCache(cacheName, unwrap));
                this.caches.put(cacheName, cache);
                return cache;
            }
            ConfigurationMerger.ConfigHolder configHolder = this.configurationMerger.mergeConfigurations(cacheName, config);
            try {
                ehCache = this.ehCacheManager.createCache(cacheName, configHolder.cacheConfiguration);
            }
            catch (Throwable t) {
                MultiCacheException mce = new MultiCacheException(t);
                configHolder.cacheResources.closeResources(mce);
                throw mce;
            }
            Eh107Cache cache = null;
            CacheResources cacheResources = configHolder.cacheResources;
            try {
                if (configHolder.useEhcacheLoaderWriter) {
                    cacheResources = new CacheResources(cacheName, EhcacheHackAccessor.getCacheLoaderWriter((Ehcache)ehCache), cacheResources.getExpiryPolicy(), cacheResources.getListenerResources());
                }
                cache = new Eh107Cache(cacheName, new Eh107CompleteConfiguration(configHolder.jsr107Configuration, ehCache.getRuntimeConfiguration()), cacheResources, ehCache, this, this.managementRegistry);
                this.caches.put(cacheName, cache);
                if (configHolder.jsr107Configuration.isManagementEnabled()) {
                    this.enableManagement(cacheName, true);
                }
                if (configHolder.jsr107Configuration.isStatisticsEnabled()) {
                    this.enableStatistics(cacheName, true);
                }
                return cache;
            }
            catch (Throwable t) {
                MultiCacheException mce = new MultiCacheException(t);
                if (cache != null) {
                    cache.closeInternal(mce);
                } else {
                    cacheResources.closeResources(mce);
                }
                throw mce;
            }
        }
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException(this.toString() + " is closed");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.uri + "]";
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        this.checkClosed();
        if (cacheName == null || keyType == null || valueType == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = (Eh107Cache)this.caches.get(cacheName);
        if (cache == null) {
            return null;
        }
        Class actualKeyType = cache.getConfiguration(javax.cache.configuration.Configuration.class).getKeyType();
        Class actualValueType = cache.getConfiguration(javax.cache.configuration.Configuration.class).getValueType();
        if (keyType != actualKeyType) {
            throw new ClassCastException("Cache has key type " + actualKeyType.getName() + ", but getCache() called with key type " + keyType.getName());
        }
        if (valueType != actualValueType) {
            throw new ClassCastException("Cache has value type " + actualValueType.getName() + ", but getCache() called with value type " + valueType.getName());
        }
        return cache;
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = (Eh107Cache)this.caches.get(cacheName);
        if (cache == null) {
            return null;
        }
        if (cache.getConfiguration(javax.cache.configuration.Configuration.class).getKeyType() != Object.class || cache.getConfiguration(javax.cache.configuration.Configuration.class).getValueType() != Object.class) {
            throw new IllegalArgumentException("Cache [" + cacheName + "] specifies key/value types. Use getCache(String, Class, Class)");
        }
        return cache;
    }

    public Iterable<String> getCacheNames() {
        return Collections.unmodifiableList(new ArrayList(this.caches.keySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCache(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException();
        }
        MultiCacheException destroyException = new MultiCacheException();
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            Eh107Cache cache = (Eh107Cache)this.caches.remove(cacheName);
            if (cache == null) {
                return;
            }
            try {
                this.enableManagement(cache, false);
            }
            catch (Throwable t) {
                destroyException.addThrowable(t);
            }
            try {
                this.enableStatistics(cache, false);
            }
            catch (Throwable t) {
                destroyException.addThrowable(t);
            }
            cache.destroy(destroyException);
            try {
                this.ehCacheManager.removeCache(cache.getName());
            }
            catch (Throwable t) {
                destroyException.addThrowable(t);
            }
        }
        destroyException.throwIfNotEmpty();
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = (Eh107Cache)this.caches.get(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("No such Cache named " + cacheName);
        }
        this.enableManagement(cache, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableManagement(Eh107Cache<?, ?> cache, boolean enabled) {
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            if (enabled) {
                this.registerObject(cache.getManagementMBean());
            } else {
                this.unregisterObject(cache.getManagementMBean());
            }
            cache.setManagementEnabled(enabled);
        }
    }

    private void unregisterObject(Eh107MXBean bean) {
        try {
            MBEAN_SERVER.unregisterMBean(bean.getObjectName());
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private void registerObject(Eh107MXBean bean) {
        try {
            MBEAN_SERVER.registerMBean(bean, bean.getObjectName());
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = (Eh107Cache)this.caches.get(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("No such Cache named " + cacheName);
        }
        this.enableStatistics(cache, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableStatistics(Eh107Cache<?, ?> cache, boolean enabled) {
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            if (enabled) {
                this.registerObject(cache.getStatisticsMBean());
            } else {
                this.unregisterObject(cache.getStatisticsMBean());
            }
            cache.setStatisticsEnabled(enabled);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public <T> T unwrap(Class<T> clazz) {
        return Unwrap.unwrap(clazz, this, this.ehCacheManager);
    }

    public void close() {
        MultiCacheException closeException = new MultiCacheException();
        this.cachingProvider.close(this, closeException);
        closeException.throwIfNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInternal(MultiCacheException closeException) {
        try {
            Object object = this.cachesLock;
            synchronized (object) {
                if (this.closed.compareAndSet(false, true)) {
                    for (Eh107Cache cache : this.caches.values()) {
                        try {
                            this.close(cache, closeException);
                        }
                        catch (Throwable t) {
                            closeException.addThrowable(t);
                        }
                    }
                    try {
                        this.caches.clear();
                    }
                    catch (Throwable t) {
                        closeException.addThrowable(t);
                    }
                    try {
                        this.ehCacheManager.close();
                    }
                    catch (Throwable t) {
                        closeException.addThrowable(t);
                    }
                }
            }
        }
        catch (Throwable t) {
            closeException.addThrowable(t);
        }
    }

    void close(Eh107Cache<?, ?> cache, MultiCacheException closeException) {
        block10: {
            try {
                if (!this.caches.remove(cache.getName(), cache)) break block10;
                try {
                    this.unregisterObject(cache.getManagementMBean());
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
                try {
                    this.unregisterObject(cache.getStatisticsMBean());
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
                try {
                    cache.closeInternal(closeException);
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
                try {
                    this.ehCacheManager.removeCache(cache.getName());
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
            }
            catch (Throwable t) {
                closeException.addThrowable(t);
            }
        }
    }
}

