/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.cache.CacheException;

public class MultiCacheException
extends CacheException {
    private static final long serialVersionUID = -6839700789356356261L;
    private final List<Throwable> throwables = new ArrayList<Throwable>();

    public MultiCacheException() {
    }

    public MultiCacheException(Throwable t) {
        this.addThrowable(t);
    }

    public void addThrowable(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (t == this) {
            throw new IllegalArgumentException("cannot add to self");
        }
        if (t instanceof MultiCacheException) {
            for (Throwable t2 : ((MultiCacheException)((Object)t)).getThrowables()) {
                this.throwables.add(t2);
            }
        } else {
            this.throwables.add(t);
        }
    }

    public List<Throwable> getThrowables() {
        return Collections.unmodifiableList(this.throwables);
    }

    public String getMessage() {
        if (this.throwables.isEmpty()) {
            return super.getMessage();
        }
        return "Contains " + this.throwables.size() + " additional exception(s)";
    }

    public Throwable initCause(Throwable cause) {
        throw new UnsupportedOperationException();
    }

    public Throwable getCause() {
        return null;
    }

    public void printStackTrace() {
        super.printStackTrace();
        for (int i = 0; i < this.throwables.size(); ++i) {
            System.err.print("  [Exception " + i + "] ");
            this.throwables.get(i).printStackTrace();
        }
    }

    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        for (int i = 0; i < this.throwables.size(); ++i) {
            ps.print("  [Exception " + i + "] ");
            this.throwables.get(i).printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        for (int i = 0; i < this.throwables.size(); ++i) {
            pw.print("  [Exception " + i + "] ");
            this.throwables.get(i).printStackTrace(pw);
        }
    }

    public void throwIfNotEmpty() {
        if (!this.throwables.isEmpty()) {
            Throwable t;
            if (this.throwables.size() == 1 && (t = this.throwables.get(0)) instanceof CacheException) {
                throw (CacheException)t;
            }
            throw this;
        }
    }
}

