/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.ehcache.jsr107.Eh107CacheLoaderWriter;
import org.ehcache.jsr107.Eh107Expiry;
import org.ehcache.jsr107.EventListenerAdaptors;
import org.ehcache.jsr107.ExpiryPolicyToEhcacheExpiry;
import org.ehcache.jsr107.MultiCacheException;
import org.ehcache.jsr107.NullCacheEntryEventFilter;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;

class CacheResources<K, V> {
    private final Eh107Expiry<K, V> expiryPolicy;
    private final CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private final Map<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>> listenerResources = new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final String cacheName;

    CacheResources(String cacheName, CompleteConfiguration<K, V> config) {
        this.cacheName = cacheName;
        MultiCacheException mce = new MultiCacheException();
        try {
            this.cacheLoaderWriter = this.initCacheLoaderWriter(config, mce);
            this.expiryPolicy = this.initExpiryPolicy(config, mce);
            this.initCacheEventListeners(config, mce);
        }
        catch (Throwable t) {
            if (t != mce) {
                mce.addThrowable(t);
            }
            try {
                this.closeResources(mce);
            }
            catch (Throwable ignore) {
                mce.addThrowable(t);
            }
            throw mce;
        }
    }

    CacheResources(String cacheName, CacheLoaderWriter<? super K, V> cacheLoaderWriter, Eh107Expiry<K, V> expiry) {
        this.cacheName = cacheName;
        this.cacheLoaderWriter = cacheLoaderWriter;
        this.expiryPolicy = expiry;
    }

    private Eh107Expiry<K, V> initExpiryPolicy(CompleteConfiguration<K, V> config, MultiCacheException mce) {
        return new ExpiryPolicyToEhcacheExpiry((ExpiryPolicy)config.getExpiryPolicyFactory().create());
    }

    private void initCacheEventListeners(CompleteConfiguration<K, V> config, MultiCacheException mce) {
        for (CacheEntryListenerConfiguration listenerConfig : config.getCacheEntryListenerConfigurations()) {
            this.listenerResources.put(listenerConfig, this.createListenerResources(listenerConfig, mce));
        }
    }

    Eh107Expiry<K, V> getExpiryPolicy() {
        return this.expiryPolicy;
    }

    CacheLoaderWriter<? super K, V> getCacheLoaderWriter() {
        return this.cacheLoaderWriter;
    }

    Map<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>> getListenerResources() {
        return Collections.unmodifiableMap(this.listenerResources);
    }

    synchronized ListenerResources<K, V> registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerConfig) {
        this.checkClosed();
        if (this.listenerResources.containsKey(listenerConfig)) {
            throw new IllegalArgumentException("listener config already registered");
        }
        MultiCacheException mce = new MultiCacheException();
        ListenerResources<K, V> rv = this.createListenerResources(listenerConfig, mce);
        mce.throwIfNotEmpty();
        this.listenerResources.put(listenerConfig, rv);
        return rv;
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("cache resources closed for cache [" + this.cacheName + "]");
        }
    }

    synchronized ListenerResources<K, V> deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerConfig) {
        this.checkClosed();
        ListenerResources<K, V> resources = this.listenerResources.remove(listenerConfig);
        if (resources == null) {
            return null;
        }
        MultiCacheException mce = new MultiCacheException();
        CacheResources.close(resources, mce);
        mce.throwIfNotEmpty();
        return resources;
    }

    private ListenerResources<K, V> createListenerResources(CacheEntryListenerConfiguration<K, V> listenerConfig, MultiCacheException mce) {
        CacheEntryEventFilter filter;
        CacheEntryListener listener = (CacheEntryListener)listenerConfig.getCacheEntryListenerFactory().create();
        try {
            Factory filterFactory = listenerConfig.getCacheEntryEventFilterFactory();
            filter = filterFactory != null ? (CacheEntryEventFilter)listenerConfig.getCacheEntryEventFilterFactory().create() : NullCacheEntryEventFilter.INSTANCE;
        }
        catch (Throwable t) {
            mce.addThrowable(t);
            CacheResources.close(listener, mce);
            throw mce;
        }
        try {
            return new ListenerResources(listener, filter);
        }
        catch (Throwable t) {
            mce.addThrowable(t);
            CacheResources.close(filter, mce);
            CacheResources.close(listener, mce);
            throw mce;
        }
    }

    private CacheLoaderWriter<K, V> initCacheLoaderWriter(CompleteConfiguration<K, V> config, MultiCacheException mce) {
        CacheWriter cacheWriter;
        Factory cacheLoaderFactory = config.getCacheLoaderFactory();
        Factory<CacheWriter<K, V>> cacheWriterFactory = CacheResources.getCacheWriterFactory(config);
        CacheLoader cacheLoader = cacheLoaderFactory == null ? null : (CacheLoader)cacheLoaderFactory.create();
        try {
            cacheWriter = cacheWriterFactory == null ? null : (CacheWriter)cacheWriterFactory.create();
        }
        catch (Throwable t) {
            if (t != mce) {
                mce.addThrowable(t);
            }
            CacheResources.close(cacheLoader, mce);
            throw mce;
        }
        if (cacheLoader == null && cacheWriter == null) {
            return null;
        }
        return new Eh107CacheLoaderWriter(cacheLoader, cacheWriter);
    }

    private static <K, V> Factory<CacheWriter<K, V>> getCacheWriterFactory(CompleteConfiguration<K, V> config) {
        Factory factory = config.getCacheWriterFactory();
        return factory;
    }

    synchronized void closeResources(MultiCacheException mce) {
        if (this.closed.compareAndSet(false, true)) {
            CacheResources.close(this.expiryPolicy, mce);
            CacheResources.close(this.cacheLoaderWriter, mce);
            for (ListenerResources<K, V> lr : this.listenerResources.values()) {
                CacheResources.close(lr, mce);
            }
        }
    }

    boolean isClosed() {
        return this.closed.get();
    }

    private static void close(Object obj, MultiCacheException mce) {
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (Throwable t) {
                mce.addThrowable(t);
            }
        }
    }

    static class ListenerResources<K, V>
    implements Closeable {
        private final CacheEntryListener<? super K, ? super V> listener;
        private final CacheEntryEventFilter<? super K, ? super V> filter;
        private List<EventListenerAdaptors.EventListenerAdaptor<K, V>> ehListeners = null;

        ListenerResources(CacheEntryListener<? super K, ? super V> listener, CacheEntryEventFilter<? super K, ? super V> filter) {
            this.listener = listener;
            this.filter = filter;
        }

        CacheEntryEventFilter<? super K, ? super V> getFilter() {
            return this.filter;
        }

        CacheEntryListener<? super K, ? super V> getListener() {
            return this.listener;
        }

        synchronized List<EventListenerAdaptors.EventListenerAdaptor<K, V>> getEhcacheListeners(Cache<K, V> source, boolean requestsOld) {
            if (this.ehListeners == null) {
                this.ehListeners = EventListenerAdaptors.ehListenersFor(this.listener, this.filter, source, requestsOld);
            }
            return Collections.unmodifiableList(this.ehListeners);
        }

        @Override
        public void close() throws IOException {
            MultiCacheException mce = new MultiCacheException();
            CacheResources.close(this.listener, mce);
            CacheResources.close(this.filter, mce);
            mce.throwIfNotEmpty();
        }
    }
}

