/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.store;

import org.ehcache.clustered.common.PoolAllocation;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.terracotta.entity.StateDumpCollector;

class ClusterTierDump {
    ClusterTierDump() {
    }

    static void dump(StateDumpCollector dump, String managerIdentifier, String storeIdentifier, ServerStoreConfiguration configuration) {
        dump.addState("managerIdentifier", (Object)managerIdentifier);
        dump.addState("storeIdentifier", (Object)storeIdentifier);
        StateDumpCollector configDump = dump.subStateDumpCollector("configuration");
        configDump.addState("storedKeyType", (Object)configuration.getStoredKeyType());
        configDump.addState("storedValueType", (Object)configuration.getStoredValueType());
        configDump.addState("keySerializerType", (Object)configuration.getKeySerializerType());
        configDump.addState("valueSerializerType", (Object)configuration.getValueSerializerType());
        configDump.addState("consistency", (Object)configuration.getConsistency().name());
        StateDumpCollector poolDump = configDump.subStateDumpCollector("pool");
        PoolAllocation pool = configuration.getPoolAllocation();
        if (pool instanceof PoolAllocation.SharedPoolAllocation) {
            poolDump.addState("resourceName", (Object)((PoolAllocation.SharedPoolAllocation)pool).getResourcePoolName());
        } else if (pool instanceof PoolAllocation.DedicatedPoolAllocation) {
            PoolAllocation.DedicatedPoolAllocation dedicatedPool = (PoolAllocation.DedicatedPoolAllocation)pool;
            poolDump.addState("resourceName", (Object)dedicatedPool.getResourceName());
            poolDump.addState("size", (Object)String.valueOf(dedicatedPool.getSize()));
        }
    }
}

