/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.store;

import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.exceptions.LifecycleException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.ClusterTierEntityConfiguration;
import org.ehcache.clustered.server.KeySegmentMapper;
import org.ehcache.clustered.server.ServerSideServerStore;
import org.ehcache.clustered.server.internal.messages.EhcacheDataSyncMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheMessageTrackerCatchup;
import org.ehcache.clustered.server.internal.messages.EhcacheMessageTrackerMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheStateRepoSyncMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheSyncMessage;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessage;
import org.ehcache.clustered.server.management.ClusterTierManagement;
import org.ehcache.clustered.server.state.EhcacheStateContext;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.ehcache.clustered.server.state.config.EhcacheStoreStateServiceConfig;
import org.ehcache.clustered.server.store.ClusterTierActiveEntity;
import org.ehcache.clustered.server.store.ClusterTierDump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.client.message.tracker.OOOMessageHandler;
import org.terracotta.client.message.tracker.OOOMessageHandlerConfiguration;
import org.terracotta.client.message.tracker.RecordedMessage;
import org.terracotta.entity.ClientSourceId;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityUserException;
import org.terracotta.entity.InvokeContext;
import org.terracotta.entity.PassiveServerEntity;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceException;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.entity.StateDumpCollector;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;

public class ClusterTierPassiveEntity
implements PassiveServerEntity<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTierPassiveEntity.class);
    private final EhcacheStateService stateService;
    private final OOOMessageHandler<EhcacheEntityMessage, EhcacheEntityResponse> messageHandler;
    private final String storeIdentifier;
    private final ClusterTierManagement management;
    private final ServerStoreConfiguration configuration;
    private final String managerIdentifier;

    public ClusterTierPassiveEntity(ServiceRegistry registry, ClusterTierEntityConfiguration config, KeySegmentMapper defaultMapper) throws ConfigurationException {
        if (config == null) {
            throw new ConfigurationException("ClusterTierManagerConfiguration cannot be null");
        }
        this.storeIdentifier = config.getStoreIdentifier();
        this.configuration = config.getConfiguration();
        this.managerIdentifier = config.getManagerIdentifier();
        try {
            this.stateService = (EhcacheStateService)registry.getService((ServiceConfiguration)new EhcacheStoreStateServiceConfig(config.getManagerIdentifier(), defaultMapper));
            this.messageHandler = (OOOMessageHandler)registry.getService((ServiceConfiguration)new OOOMessageHandlerConfiguration(this.managerIdentifier + "###" + this.storeIdentifier, ClusterTierActiveEntity::isTrackedMessage));
        }
        catch (ServiceException e) {
            throw new ConfigurationException("Unable to retrieve service: " + e.getMessage());
        }
        if (this.stateService == null) {
            throw new AssertionError((Object)"Server failed to retrieve EhcacheStateService.");
        }
        this.management = new ClusterTierManagement(registry, this.stateService, false, this.storeIdentifier, config.getManagerIdentifier());
    }

    protected EhcacheStateService getStateService() {
        return this.stateService;
    }

    protected String getStoreIdentifier() {
        return this.storeIdentifier;
    }

    public void addStateTo(StateDumpCollector dump) {
        ClusterTierDump.dump(dump, this.managerIdentifier, this.storeIdentifier, this.configuration);
    }

    public void createNew() throws ConfigurationException {
        this.stateService.createStore(this.storeIdentifier, this.configuration, false);
        this.management.entityCreated();
    }

    private boolean isEventual() {
        return this.configuration.getConsistency() == Consistency.EVENTUAL;
    }

    public void invokePassive(final InvokeContext context, final EhcacheEntityMessage message) throws EntityUserException {
        InvokeContext realContext = context;
        if (message instanceof PassiveReplicationMessage.ChainReplicationMessage) {
            realContext = new InvokeContext(){

                public ClientSourceId getClientSource() {
                    return context.makeClientSourceId(((PassiveReplicationMessage.ChainReplicationMessage)message).getClientId());
                }

                public long getCurrentTransactionId() {
                    return ((PassiveReplicationMessage.ChainReplicationMessage)message).getTransactionId();
                }

                public long getOldestTransactionId() {
                    return ((PassiveReplicationMessage.ChainReplicationMessage)message).getOldestTransactionId();
                }

                public boolean isValidClientInformation() {
                    return true;
                }

                public ClientSourceId makeClientSourceId(long l) {
                    return context.makeClientSourceId(l);
                }

                public int getConcurrencyKey() {
                    return context.getConcurrencyKey();
                }
            };
        }
        this.messageHandler.invoke(realContext, (EntityMessage)message, this::invokePassiveInternal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EhcacheEntityResponse invokePassiveInternal(InvokeContext context, EhcacheEntityMessage message) {
        if (message instanceof EhcacheOperationMessage) {
            EhcacheOperationMessage operationMessage = (EhcacheOperationMessage)message;
            try (EhcacheStateContext ignored = this.stateService.beginProcessing(operationMessage, this.storeIdentifier);){
                EhcacheMessageType messageType = operationMessage.getMessageType();
                if (EhcacheMessageType.isStoreOperationMessage((EhcacheMessageType)messageType)) {
                    this.invokeServerStoreOperation((ServerStoreOpMessage)message);
                    return EhcacheEntityResponse.success();
                }
                if (EhcacheMessageType.isStateRepoOperationMessage((EhcacheMessageType)messageType)) {
                    EhcacheEntityResponse ehcacheEntityResponse = this.stateService.getStateRepositoryManager().invoke((StateRepositoryOpMessage)message);
                    return ehcacheEntityResponse;
                }
                if (!EhcacheMessageType.isPassiveReplicationMessage((EhcacheMessageType)messageType)) throw new AssertionError((Object)("Unsupported EhcacheOperationMessage: " + operationMessage.getMessageType()));
                EhcacheEntityResponse ehcacheEntityResponse = this.invokeRetirementMessages((PassiveReplicationMessage)message);
                return ehcacheEntityResponse;
            }
            catch (ClusterException | OversizeMappingException e) {
                LOGGER.error("Unexpected exception raised during operation: " + message, e);
                return EhcacheEntityResponse.success();
            }
        }
        if (message instanceof EhcacheSyncMessage) {
            this.invokeSyncOperation(context, (EhcacheSyncMessage)message);
            return EhcacheEntityResponse.success();
        }
        if (!(message instanceof EhcacheMessageTrackerCatchup)) throw new AssertionError((Object)("Unsupported EhcacheEntityMessage: " + message.getClass()));
        this.invokeCatchup(context, (EhcacheMessageTrackerCatchup)message);
        return EhcacheEntityResponse.success();
    }

    private void invokeCatchup(final InvokeContext context, EhcacheMessageTrackerCatchup catchup) {
        catchup.getTrackedMessages().forEach(r -> {
            InvokeContext replay = new InvokeContext((RecordedMessage)r){
                final /* synthetic */ RecordedMessage val$r;
                {
                    this.val$r = recordedMessage;
                }

                public ClientSourceId getClientSource() {
                    return context.makeClientSourceId(this.val$r.getClientSourceId().toLong());
                }

                public long getCurrentTransactionId() {
                    return this.val$r.getTransactionId();
                }

                public long getOldestTransactionId() {
                    return context.getOldestTransactionId();
                }

                public boolean isValidClientInformation() {
                    return true;
                }

                public ClientSourceId makeClientSourceId(long l) {
                    return context.makeClientSourceId(l);
                }

                public int getConcurrencyKey() {
                    return 0;
                }
            };
            try {
                this.messageHandler.invoke(replay, (EntityMessage)r.getRequest(), this::invokePassiveInternal);
            }
            catch (EntityUserException entityUserException) {
                // empty catch block
            }
        });
    }

    private void invokeSyncOperation(final InvokeContext context, EhcacheSyncMessage message) {
        switch (message.getMessageType()) {
            case DATA: {
                EhcacheDataSyncMessage dataSyncMessage = (EhcacheDataSyncMessage)message;
                ServerSideServerStore store = this.stateService.getStore(this.storeIdentifier);
                dataSyncMessage.getChainMap().forEach((arg_0, arg_1) -> ((ServerSideServerStore)store).put(arg_0, arg_1));
                break;
            }
            case STATE_REPO: {
                EhcacheStateRepoSyncMessage stateRepoSyncMessage = (EhcacheStateRepoSyncMessage)message;
                this.stateService.getStateRepositoryManager().processSyncMessage(stateRepoSyncMessage);
                break;
            }
            case MESSAGE_TRACKER: {
                EhcacheMessageTrackerMessage messageTrackerMessage = (EhcacheMessageTrackerMessage)message;
                Stream converted = messageTrackerMessage.getTrackedMessages().entrySet().stream().flatMap(e -> ((Map)e.getValue()).entrySet().stream().map(v -> new RecordedMessage<EhcacheEntityMessage, EhcacheEntityResponse>(){

                    public ClientSourceId getClientSourceId() {
                        return context.makeClientSourceId(((Long)e.getKey()).longValue());
                    }

                    public long getTransactionId() {
                        return (Long)v.getKey();
                    }

                    public EhcacheEntityMessage getRequest() {
                        return null;
                    }

                    public EhcacheEntityResponse getResponse() {
                        return (EhcacheEntityResponse)v.getValue();
                    }
                }));
                this.messageHandler.loadRecordedMessages(converted);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported Sync operation " + message.getMessageType()));
            }
        }
    }

    private EhcacheEntityResponse invokeRetirementMessages(PassiveReplicationMessage message) throws ClusterException {
        switch (message.getMessageType()) {
            case CHAIN_REPLICATION_OP: {
                PassiveReplicationMessage.ChainReplicationMessage retirementMessage = (PassiveReplicationMessage.ChainReplicationMessage)message;
                LOGGER.debug("Chain Replication message for transactionId {} & clientId {}", (Object)retirementMessage.getTransactionId(), (Object)retirementMessage.getClientId());
                ServerSideServerStore cacheStore = this.stateService.getStore(this.storeIdentifier);
                if (cacheStore == null) {
                    throw new LifecycleException("cluster tier does not exist : '" + this.storeIdentifier + "'");
                }
                if (this.isEventual()) {
                    this.stateService.getInvalidationTracker(this.storeIdentifier).trackHashInvalidation(retirementMessage.getKey());
                }
                cacheStore.put(retirementMessage.getKey(), retirementMessage.getChain());
                return EhcacheEntityResponse.getResponse((Chain)retirementMessage.getResult());
            }
            case INVALIDATION_COMPLETE: {
                if (!this.isEventual()) break;
                PassiveReplicationMessage.InvalidationCompleteMessage invalidationCompleteMessage = (PassiveReplicationMessage.InvalidationCompleteMessage)message;
                this.stateService.getInvalidationTracker(this.storeIdentifier).untrackHashInvalidation(invalidationCompleteMessage.getKey());
                break;
            }
            case CLEAR_INVALIDATION_COMPLETE: {
                if (!this.isEventual()) break;
                this.stateService.getInvalidationTracker(this.storeIdentifier).setClearInProgress(false);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported Retirement Message : " + (Object)((Object)message)));
            }
        }
        return null;
    }

    private void invokeServerStoreOperation(ServerStoreOpMessage message) throws ClusterException {
        ServerSideServerStore cacheStore = this.stateService.getStore(this.storeIdentifier);
        if (cacheStore == null) {
            throw new LifecycleException("cluster tier does not exist : '" + this.storeIdentifier + "'");
        }
        switch (message.getMessageType()) {
            case REPLACE: {
                ServerStoreOpMessage.ReplaceAtHeadMessage replaceAtHeadMessage = (ServerStoreOpMessage.ReplaceAtHeadMessage)message;
                cacheStore.replaceAtHead(replaceAtHeadMessage.getKey(), replaceAtHeadMessage.getExpect(), replaceAtHeadMessage.getUpdate());
                break;
            }
            case INSERT_FULL_CHAIN: {
                ServerStoreOpMessage.InsertFullChainMessage insertFullChainMessage = (ServerStoreOpMessage.InsertFullChainMessage)message;
                cacheStore.put(insertFullChainMessage.getKey(), insertFullChainMessage.getChain());
                break;
            }
            case CLEAR: {
                LOGGER.info("Clearing cluster tier {}", (Object)this.storeIdentifier);
                try {
                    cacheStore.clear();
                }
                catch (TimeoutException e) {
                    throw new AssertionError((Object)"Server side store is not expected to throw timeout exception");
                }
                if (!this.isEventual()) break;
                this.stateService.getInvalidationTracker(this.storeIdentifier).setClearInProgress(true);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported ServerStore operation : " + message.getMessageType()));
            }
        }
    }

    public void startSyncEntity() {
        LOGGER.info("Sync started.");
    }

    public void endSyncEntity() {
        LOGGER.info("Sync completed.");
    }

    public void startSyncConcurrencyKey(int concurrencyKey) {
        LOGGER.info("Sync started for concurrency key {}.", (Object)concurrencyKey);
    }

    public void endSyncConcurrencyKey(int concurrencyKey) {
        LOGGER.info("Sync complete for concurrency key {}.", (Object)concurrencyKey);
    }

    public void destroy() {
        LOGGER.info("Destroying cluster tier '{}'", (Object)this.storeIdentifier);
        try {
            this.stateService.destroyServerStore(this.storeIdentifier);
        }
        catch (ClusterException e) {
            throw new AssertionError((Object)e);
        }
        this.management.close();
        this.messageHandler.destroy();
    }

    public void notifyDestroyed(ClientSourceId sourceId) {
        this.messageHandler.untrackClient(sourceId);
    }
}

