/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ehcache.clustered.common.internal.messages.ConcurrentEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.server.KeySegmentMapper;
import org.ehcache.clustered.server.internal.messages.EhcacheMessageTrackerCatchup;
import org.terracotta.entity.ConcurrencyStrategy;

public final class ConcurrencyStrategies {
    public static final int DEFAULT_KEY = 1;
    private static final ConcurrencyStrategy<EhcacheEntityMessage> CLUSTER_TIER_MANAGER_CONCURRENCY_STRATEGY = new ConcurrencyStrategy<EhcacheEntityMessage>(){

        public int concurrencyKey(EhcacheEntityMessage message) {
            return 1;
        }

        public Set<Integer> getKeysForSynchronization() {
            return Collections.singleton(1);
        }
    };

    private ConcurrencyStrategies() {
    }

    public static ConcurrencyStrategy<EhcacheEntityMessage> clusterTierConcurrency(KeySegmentMapper mapper) {
        return new DefaultConcurrencyStrategy(mapper);
    }

    public static ConcurrencyStrategy<EhcacheEntityMessage> clusterTierManagerConcurrency() {
        return CLUSTER_TIER_MANAGER_CONCURRENCY_STRATEGY;
    }

    public static class DefaultConcurrencyStrategy
    implements ConcurrencyStrategy<EhcacheEntityMessage> {
        public static final int DATA_CONCURRENCY_KEY_OFFSET = 2;
        public static final int TRACKER_SYNC_KEY = 0x7FFFFFFE;
        private final KeySegmentMapper mapper;

        public DefaultConcurrencyStrategy(KeySegmentMapper mapper) {
            this.mapper = mapper;
        }

        public int concurrencyKey(EhcacheEntityMessage entityMessage) {
            if (entityMessage instanceof ServerStoreOpMessage.GetMessage) {
                return Integer.MIN_VALUE;
            }
            if (entityMessage instanceof ConcurrentEntityMessage) {
                ConcurrentEntityMessage concurrentEntityMessage = (ConcurrentEntityMessage)entityMessage;
                return 2 + this.mapper.getSegmentForKey(concurrentEntityMessage.concurrencyKey());
            }
            if (entityMessage instanceof EhcacheMessageTrackerCatchup) {
                return 0;
            }
            return 1;
        }

        public Set<Integer> getKeysForSynchronization() {
            LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
            for (int i = 0; i <= this.mapper.getSegments(); ++i) {
                result.add(1 + i);
            }
            result.add(0x7FFFFFFE);
            return Collections.unmodifiableSet(result);
        }
    }
}

