/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.io.Serializable;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;

public abstract class StateRepositoryOpMessage
extends EhcacheOperationMessage
implements Serializable {
    private static final long serialVersionUID = -6701802926010996981L;
    private final String cacheId;
    private final String mapId;

    private StateRepositoryOpMessage(String cacheId, String mapId) {
        this.cacheId = cacheId;
        this.mapId = mapId;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public String getMapId() {
        return this.mapId;
    }

    public static class EntrySetMessage
    extends StateRepositoryOpMessage {
        private static final long serialVersionUID = 5230634750732779978L;

        public EntrySetMessage(String cacheId, String mapId) {
            super(cacheId, mapId);
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.ENTRY_SET;
        }
    }

    public static class RemoveMessage
    extends KeyBasedMessage {
        private static final long serialVersionUID = 7263513962868446471L;
        private final Object value;

        public RemoveMessage(String cacheId, String mapId, Object key, Object value) {
            super(cacheId, mapId, key);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.REMOVE;
        }
    }

    public static class PutIfAbsentMessage
    extends KeyBasedMessage {
        private static final long serialVersionUID = 2743653481411126124L;
        private final Object value;

        public PutIfAbsentMessage(String cacheId, String mapId, Object key, Object value) {
            super(cacheId, mapId, key);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.PUT_IF_ABSENT;
        }
    }

    public static class GetMessage
    extends KeyBasedMessage {
        private static final long serialVersionUID = 7263513962868446470L;

        public GetMessage(String cacheId, String mapId, Object key) {
            super(cacheId, mapId, key);
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.GET_STATE_REPO;
        }
    }

    private static abstract class KeyBasedMessage
    extends StateRepositoryOpMessage {
        private static final long serialVersionUID = 2338704755924839309L;
        private final Object key;

        private KeyBasedMessage(String cacheId, String mapId, Object key) {
            super(cacheId, mapId);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

