/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.internal.ClusterTierManagerClientEntity;
import org.ehcache.clustered.client.internal.ClusterTierManagerClientEntityFactory;
import org.ehcache.clustered.client.internal.ClusterTierManagerCreationException;
import org.ehcache.clustered.client.internal.ClusterTierManagerValidationException;
import org.ehcache.clustered.client.internal.ConnectionSource;
import org.ehcache.clustered.client.internal.PerpetualCachePersistenceException;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.service.EntityBusyException;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.DestroyInProgressException;
import org.ehcache.core.util.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.ConnectionShutdownException;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityNotFoundException;

class ConnectionState {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionState.class);
    private static final String CONNECTION_PREFIX = "Ehcache:";
    private volatile Executor asyncWorker;
    private volatile Connection clusterConnection = null;
    private volatile ClusterTierManagerClientEntityFactory entityFactory = null;
    private volatile ClusterTierManagerClientEntity entity = null;
    private final AtomicInteger reconnectCounter = new AtomicInteger();
    private final ConcurrentMap<String, ClusterTierClientEntity> clusterTierEntities = new ConcurrentHashMap<String, ClusterTierClientEntity>();
    private final Timeouts timeouts;
    private final ConnectionSource connectionSource;
    private final String entityIdentifier;
    private final Properties connectionProperties;
    private final ClusteringServiceConfiguration serviceConfiguration;
    private Runnable connectionRecoveryListener = () -> {};

    ConnectionState(Timeouts timeouts, Properties connectionProperties, ClusteringServiceConfiguration serviceConfiguration) {
        this.timeouts = timeouts;
        this.connectionSource = serviceConfiguration.getConnectionSource();
        this.entityIdentifier = this.connectionSource.getClusterTierManager();
        this.connectionProperties = connectionProperties;
        connectionProperties.put("connection.name", CONNECTION_PREFIX + this.entityIdentifier);
        connectionProperties.put("connection.timeout", Long.toString(timeouts.getConnectionTimeout().toMillis()));
        this.serviceConfiguration = serviceConfiguration;
    }

    public void setConnectionRecoveryListener(Runnable connectionRecoveryListener) {
        this.connectionRecoveryListener = connectionRecoveryListener;
    }

    public Connection getConnection() {
        return this.clusterConnection;
    }

    public ClusterTierClientEntity getClusterTierClientEntity(String cacheId) {
        return (ClusterTierClientEntity)this.clusterTierEntities.get(cacheId);
    }

    public ClusterTierManagerClientEntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public ClusterTierManagerClientEntity getEntity() {
        return this.entity;
    }

    public ClusterTierClientEntity createClusterTierClientEntity(String cacheId, ServerStoreConfiguration clientStoreConfiguration, boolean isReconnect) throws CachePersistenceException {
        ClusterTierClientEntity storeClientEntity;
        while (true) {
            try {
                storeClientEntity = this.entityFactory.fetchOrCreateClusteredStoreEntity(this.entityIdentifier, cacheId, clientStoreConfiguration, this.serviceConfiguration.getClientMode(), isReconnect);
                this.clusterTierEntities.put(cacheId, storeClientEntity);
            }
            catch (EntityNotFoundException e) {
                throw new PerpetualCachePersistenceException("Cluster tier proxy '" + cacheId + "' for entity '" + this.entityIdentifier + "' does not exist.", e);
            }
            catch (Throwable t) {
                if (ExceptionUtil.containsCause((Throwable)t, ConnectionClosedException.class) || ExceptionUtil.containsCause((Throwable)t, ConnectionShutdownException.class)) {
                    LOGGER.info("Disconnected from the server", t);
                    this.handleConnectionClosedException(true);
                    continue;
                }
                throw t;
            }
            break;
        }
        return storeClientEntity;
    }

    public void removeClusterTierClientEntity(String cacheId) {
        this.clusterTierEntities.remove(cacheId);
    }

    public void initClusterConnection(Executor asyncWorker) {
        this.asyncWorker = Objects.requireNonNull(asyncWorker);
        try {
            this.connect();
        }
        catch (ConnectionException | ConnectionClosedException ex) {
            LOGGER.error("Initial connection failed due to", ex);
            throw new RuntimeException(ex);
        }
    }

    private void reconnect() {
        while (true) {
            try {
                try {
                    this.clusterConnection.close();
                }
                catch (IOException | IllegalStateException | ConnectionClosedException e) {
                    LOGGER.debug("Exception closing previous cluster connection", e);
                }
                this.connect();
                LOGGER.info("New connection to server is established, reconnect count is {}", (Object)this.reconnectCounter.incrementAndGet());
            }
            catch (ConnectionException | ConnectionClosedException e) {
                LOGGER.error("Re-connection to server failed, trying again", e);
                continue;
            }
            catch (Throwable t) {
                if (ExceptionUtil.containsCause((Throwable)t, ConnectionClosedException.class) || ExceptionUtil.containsCause((Throwable)t, ConnectionShutdownException.class)) {
                    LOGGER.error("Re-connection to server failed, trying again", t);
                    continue;
                }
                throw t;
            }
            break;
        }
    }

    private void connect() throws ConnectionException {
        this.clusterConnection = this.connectionSource.connect(this.connectionProperties);
        this.entityFactory = new ClusterTierManagerClientEntityFactory(this.clusterConnection, this.asyncWorker, this.timeouts);
    }

    public void closeConnection() {
        Connection conn = this.clusterConnection;
        this.clusterConnection = null;
        if (conn != null) {
            try {
                conn.close();
            }
            catch (IOException | ConnectionShutdownException e) {
                LOGGER.warn("Error closing cluster connection: " + e);
            }
        }
    }

    private boolean silentDestroyUtil() {
        try {
            this.silentDestroy();
            return true;
        }
        catch (ConnectionClosedException | ConnectionShutdownException e) {
            LOGGER.info("Disconnected from the server", e);
            this.reconnect();
            return false;
        }
        catch (Throwable t) {
            if (ExceptionUtil.containsCause((Throwable)t, ConnectionClosedException.class) || ExceptionUtil.containsCause((Throwable)t, ConnectionShutdownException.class)) {
                LOGGER.info("Disconnected from the server", t);
                this.reconnect();
                return false;
            }
            throw t;
        }
    }

    private void silentDestroy() {
        LOGGER.debug("Found a broken ClusterTierManager - trying to clean it up");
        try {
            Thread.sleep(new Random().nextInt(1000));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.entityFactory.destroy(this.entityIdentifier);
        }
        catch (EntityBusyException e) {
            LOGGER.debug("ClusterTierManager {} marked busy when trying to clean it up", (Object)this.entityIdentifier);
        }
    }

    public void acquireLeadership() {
        if (!this.entityFactory.acquireLeadership(this.entityIdentifier)) {
            this.entityFactory = null;
            this.closeConnection();
            throw new IllegalStateException("Couldn't acquire cluster-wide maintenance lease");
        }
    }

    public void initializeState() throws ClusterTierManagerValidationException {
        try {
            switch (this.serviceConfiguration.getClientMode()) {
                case CONNECT: 
                case EXPECTING: {
                    this.retrieveEntity();
                    break;
                }
                case AUTO_CREATE: 
                case AUTO_CREATE_ON_RECONNECT: {
                    this.autoCreateEntity();
                    break;
                }
                default: {
                    throw new AssertionError((Object)this.serviceConfiguration.getClientMode());
                }
            }
        }
        catch (Throwable t) {
            this.entityFactory = null;
            this.closeConnection();
            throw t;
        }
    }

    private void retrieveEntity() throws ClusterTierManagerValidationException {
        try {
            this.entity = this.entityFactory.retrieve(this.entityIdentifier, this.serviceConfiguration.getServerConfiguration());
        }
        catch (DestroyInProgressException | EntityNotFoundException e) {
            throw new IllegalStateException("The cluster tier manager '" + this.entityIdentifier + "' does not exist. Please review your configuration.", e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Could not connect to the cluster tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", e);
        }
    }

    public void destroyState(boolean healthyConnection) {
        if (this.entityFactory != null) {
            this.entityFactory.abandonAllHolds(this.entityIdentifier, healthyConnection);
        }
        this.entityFactory = null;
        this.clusterTierEntities.clear();
        this.entity = null;
    }

    public void destroyAll() throws CachePersistenceException {
        LOGGER.info("destroyAll called for cluster tiers on {}", (Object)this.connectionSource);
        while (true) {
            try {
                this.entityFactory.destroy(this.entityIdentifier);
            }
            catch (EntityBusyException e) {
                throw new CachePersistenceException("Cannot delete cluster tiers on " + this.connectionSource, (Throwable)e);
            }
            catch (ConnectionClosedException | ConnectionShutdownException e) {
                this.handleConnectionClosedException(false);
                continue;
            }
            catch (Throwable t) {
                if (ExceptionUtil.containsCause((Throwable)t, ConnectionClosedException.class) || ExceptionUtil.containsCause((Throwable)t, ConnectionShutdownException.class)) {
                    this.handleConnectionClosedException(false);
                    continue;
                }
                throw t;
            }
            break;
        }
    }

    public void destroy(String name) throws CachePersistenceException {
        while (true) {
            if (this.entity == null) {
                try {
                    this.entity = this.entityFactory.retrieve(this.entityIdentifier, this.serviceConfiguration.getServerConfiguration());
                }
                catch (EntityNotFoundException e) {
                    break;
                }
                catch (TimeoutException e) {
                    throw new CachePersistenceException("Could not connect to the cluster tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", (Throwable)e);
                }
                catch (DestroyInProgressException e) {
                    if (this.silentDestroyUtil()) {
                        break;
                    }
                }
                catch (ConnectionClosedException | ConnectionShutdownException e) {
                    this.reconnect();
                }
                catch (Throwable t) {
                    if (ExceptionUtil.containsCause((Throwable)t, ConnectionClosedException.class) || ExceptionUtil.containsCause((Throwable)t, ConnectionShutdownException.class)) {
                        this.reconnect();
                    }
                    throw t;
                }
            }
            try {
                if (this.entity == null) continue;
                this.entityFactory.destroyClusteredStoreEntity(this.entityIdentifier, name);
            }
            catch (EntityNotFoundException e) {
                LOGGER.debug("Destruction of cluster tier {} failed as it does not exist", (Object)name);
            }
            catch (ConnectionClosedException | ConnectionShutdownException e) {
                this.handleConnectionClosedException(false);
                continue;
            }
            catch (Throwable t) {
                if (ExceptionUtil.containsCause((Throwable)t, ConnectionClosedException.class) || ExceptionUtil.containsCause((Throwable)t, ConnectionShutdownException.class)) {
                    this.handleConnectionClosedException(false);
                    continue;
                }
                throw t;
            }
            break;
        }
    }

    private void autoCreateEntity() throws ClusterTierManagerValidationException, IllegalStateException {
        while (true) {
            try {
                this.entityFactory.create(this.entityIdentifier, this.serviceConfiguration.getServerConfiguration());
            }
            catch (ClusterTierManagerCreationException e) {
                throw new IllegalStateException("Could not create the cluster tier manager '" + this.entityIdentifier + "'.", e);
            }
            catch (EntityBusyException | EntityAlreadyExistsException e) {
            }
            catch (ConnectionClosedException | ConnectionShutdownException e) {
                LOGGER.info("Disconnected from the server", e);
                this.reconnect();
                continue;
            }
            catch (Throwable t) {
                if (ExceptionUtil.containsCause((Throwable)t, ConnectionClosedException.class) || ExceptionUtil.containsCause((Throwable)t, ConnectionShutdownException.class)) {
                    LOGGER.info("Disconnected from the server", t);
                    this.reconnect();
                    continue;
                }
                throw t;
            }
            try {
                this.entity = this.entityFactory.retrieve(this.entityIdentifier, this.serviceConfiguration.getServerConfiguration());
            }
            catch (DestroyInProgressException e) {
                this.silentDestroyUtil();
                continue;
            }
            catch (EntityNotFoundException e) {
                continue;
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Could not connect to the cluster tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", e);
            }
            catch (ConnectionClosedException | ConnectionShutdownException e) {
                LOGGER.info("Disconnected from the server", e);
                this.reconnect();
                continue;
            }
            catch (Throwable t) {
                if (ExceptionUtil.containsCause((Throwable)t, ConnectionClosedException.class) || ExceptionUtil.containsCause((Throwable)t, ConnectionShutdownException.class)) {
                    LOGGER.info("Disconnected from the server", t);
                    this.reconnect();
                    continue;
                }
                throw t;
            }
            break;
        }
    }

    private void handleConnectionClosedException(boolean retrieve) throws ClusterTierManagerValidationException {
        while (true) {
            try {
                this.destroyState(false);
                this.reconnect();
                if (retrieve) {
                    if (this.serviceConfiguration.getClientMode().equals((Object)ClusteringServiceConfiguration.ClientMode.AUTO_CREATE_ON_RECONNECT)) {
                        this.autoCreateEntity();
                    } else {
                        this.retrieveEntity();
                    }
                }
                this.connectionRecoveryListener.run();
            }
            catch (Throwable t) {
                if (ExceptionUtil.containsCause((Throwable)t, ConnectionClosedException.class) || ExceptionUtil.containsCause((Throwable)t, ConnectionShutdownException.class)) {
                    LOGGER.info("Disconnected from the server", t);
                    continue;
                }
                throw t;
            }
            break;
        }
    }

    int getReconnectCount() {
        return this.reconnectCounter.get();
    }
}

