/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.clustered.client.internal.store.ReconnectInProgressException;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxyException;
import org.ehcache.clustered.client.internal.store.lock.LockingServerStoreProxy;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.ServerStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.ConnectionShutdownException;

public class ReconnectingServerStoreProxy
implements LockingServerStoreProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconnectingServerStoreProxy.class);
    private final AtomicReference<LockingServerStoreProxy> delegateRef;
    private final Runnable onReconnect;

    public ReconnectingServerStoreProxy(ServerStoreProxy serverStoreProxy, Runnable onReconnect) {
        this.delegateRef = serverStoreProxy instanceof LockingServerStoreProxy ? new AtomicReference<LockingServerStoreProxy>((LockingServerStoreProxy)serverStoreProxy) : new AtomicReference<LockingServerStoreProxy>(this.unsupportedLocking(serverStoreProxy));
        this.onReconnect = onReconnect;
    }

    @Override
    public String getCacheId() {
        return this.proxy().getCacheId();
    }

    @Override
    public void close() {
        try {
            this.proxy().close();
        }
        catch (ConnectionClosedException | ConnectionShutdownException e) {
            LOGGER.debug("Store was already closed, since connection was closed");
        }
    }

    @Override
    public ServerStoreProxy.ChainEntry get(long key) throws TimeoutException {
        return this.onStoreProxy(serverStoreProxy -> serverStoreProxy.get(key));
    }

    public void append(long key, ByteBuffer payLoad) throws TimeoutException {
        this.onStoreProxy(serverStoreProxy -> {
            serverStoreProxy.append(key, payLoad);
            return null;
        });
    }

    @Override
    public ServerStoreProxy.ChainEntry getAndAppend(long key, ByteBuffer payLoad) throws TimeoutException {
        return this.onStoreProxy(serverStoreProxy -> serverStoreProxy.getAndAppend(key, payLoad));
    }

    @Override
    public void enableEvents(boolean enable) throws TimeoutException {
        this.onStoreProxy(serverStoreProxy -> {
            serverStoreProxy.enableEvents(enable);
            return null;
        });
    }

    public void replaceAtHead(long key, Chain expect, Chain update) {
        try {
            this.onStoreProxy(serverStoreProxy -> {
                serverStoreProxy.replaceAtHead(key, expect, update);
                return null;
            });
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() throws TimeoutException {
        this.onStoreProxy(serverStoreProxy -> {
            serverStoreProxy.clear();
            return null;
        });
    }

    public Iterator<Map.Entry<Long, Chain>> iterator() throws TimeoutException {
        return this.onStoreProxy(ServerStore::iterator);
    }

    private LockingServerStoreProxy proxy() {
        return this.delegateRef.get();
    }

    private <T> T onStoreProxy(TimeoutExceptionFunction<LockingServerStoreProxy, T> function) throws TimeoutException {
        LockingServerStoreProxy storeProxy = this.proxy();
        try {
            return function.apply(storeProxy);
        }
        catch (ServerStoreProxyException sspe) {
            if (sspe.getCause() instanceof ConnectionClosedException) {
                if (this.delegateRef.compareAndSet(storeProxy, new ReconnectInProgressProxy(storeProxy.getCacheId()))) {
                    this.onReconnect.run();
                }
                return this.onStoreProxy(function);
            }
            throw sspe;
        }
    }

    @Override
    public ServerStoreProxy.ChainEntry lock(long key) throws TimeoutException {
        return this.onStoreProxy(lockingServerStoreProxy -> lockingServerStoreProxy.lock(key));
    }

    @Override
    public void unlock(long key, boolean localonly) throws TimeoutException {
        this.onStoreProxy(lockingServerStoreProxy -> {
            lockingServerStoreProxy.unlock(key, localonly);
            return null;
        });
    }

    private LockingServerStoreProxy unsupportedLocking(final ServerStoreProxy serverStoreProxy) {
        return new LockingServerStoreProxy(){

            @Override
            public ServerStoreProxy.ChainEntry lock(long hash) {
                throw new UnsupportedOperationException("Lock ops are not supported");
            }

            @Override
            public void unlock(long hash, boolean localonly) {
                throw new UnsupportedOperationException("Lock ops are not supported");
            }

            @Override
            public ServerStoreProxy.ChainEntry get(long key) throws TimeoutException {
                return serverStoreProxy.get(key);
            }

            @Override
            public ServerStoreProxy.ChainEntry getAndAppend(long key, ByteBuffer payLoad) throws TimeoutException {
                return serverStoreProxy.getAndAppend(key, payLoad);
            }

            @Override
            public void enableEvents(boolean enable) throws TimeoutException {
                serverStoreProxy.enableEvents(enable);
            }

            @Override
            public String getCacheId() {
                return serverStoreProxy.getCacheId();
            }

            @Override
            public void close() {
                serverStoreProxy.close();
            }

            public void append(long key, ByteBuffer payLoad) throws TimeoutException {
                serverStoreProxy.append(key, payLoad);
            }

            public void replaceAtHead(long key, Chain expect, Chain update) {
                serverStoreProxy.replaceAtHead(key, expect, update);
            }

            public void clear() throws TimeoutException {
                serverStoreProxy.clear();
            }

            public Iterator<Map.Entry<Long, Chain>> iterator() throws TimeoutException {
                return serverStoreProxy.iterator();
            }
        };
    }

    private static class ReconnectInProgressProxy
    implements LockingServerStoreProxy {
        private final String cacheId;

        ReconnectInProgressProxy(String cacheId) {
            this.cacheId = cacheId;
        }

        @Override
        public String getCacheId() {
            return this.cacheId;
        }

        @Override
        public void close() {
            throw new ReconnectInProgressException();
        }

        @Override
        public ServerStoreProxy.ChainEntry get(long key) {
            throw new ReconnectInProgressException();
        }

        public void append(long key, ByteBuffer payLoad) {
            throw new ReconnectInProgressException();
        }

        @Override
        public ServerStoreProxy.ChainEntry getAndAppend(long key, ByteBuffer payLoad) {
            throw new ReconnectInProgressException();
        }

        public void replaceAtHead(long key, Chain expect, Chain update) {
            throw new ReconnectInProgressException();
        }

        public void clear() {
            throw new ReconnectInProgressException();
        }

        public Iterator<Map.Entry<Long, Chain>> iterator() {
            throw new ReconnectInProgressException();
        }

        @Override
        public ServerStoreProxy.ChainEntry lock(long key) {
            throw new ReconnectInProgressException();
        }

        @Override
        public void unlock(long key, boolean localonly) {
            throw new ReconnectInProgressException();
        }

        @Override
        public void enableEvents(boolean enable) {
            throw new ReconnectInProgressException();
        }
    }

    @FunctionalInterface
    private static interface TimeoutExceptionFunction<U, V> {
        public V apply(U var1) throws TimeoutException;
    }
}

