/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.clustered.client.internal.store.ClusteredValueHolder;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.operations.ChainResolver;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.operations.Operation;
import org.ehcache.clustered.common.internal.store.operations.PutOperation;
import org.ehcache.clustered.common.internal.store.operations.Result;
import org.ehcache.clustered.common.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.core.spi.store.Store;

public class EternalChainResolver<K, V>
extends ChainResolver<K, V> {
    public EternalChainResolver(OperationsCodec<K, V> codec) {
        super(codec);
    }

    @Override
    public Store.ValueHolder<V> resolve(ServerStoreProxy.ChainEntry entry, K key, long now, int threshold) {
        PutOperation resolved = this.resolve(entry, key, threshold);
        return resolved == null ? null : new ClusteredValueHolder<Object>(resolved.getValue());
    }

    @Override
    public Map<K, Store.ValueHolder<V>> resolveAll(Chain chain) {
        Map resolved = this.resolveToSimplePuts(chain);
        HashMap values = new HashMap(resolved.size());
        for (Map.Entry e : resolved.entrySet()) {
            values.put(e.getKey(), new ClusteredValueHolder<Object>(e.getValue().getValue()));
        }
        return Collections.unmodifiableMap(values);
    }

    @Override
    public Map<K, Store.ValueHolder<V>> resolveAll(Chain chain, long now) {
        return this.resolveAll(chain);
    }

    @Override
    public PutOperation<K, V> applyOperation(K key, PutOperation<K, V> existing, Operation<K, V> operation) {
        Result newValue = operation.apply(existing);
        if (newValue == null) {
            return null;
        }
        return newValue.asOperationExpiringAt(Long.MAX_VALUE);
    }
}

