/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.txmgr.btm;

import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceObjectFactory;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.common.XAStatefulHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.xa.XAResource;
import org.ehcache.transactions.xa.txmgr.btm.Ehcache3XAResourceHolder;

class Ehcache3XAResourceProducer
extends ResourceBean
implements XAResourceProducer {
    private static final long serialVersionUID = -6421881731950504009L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Map<XAResource, Ehcache3XAResourceHolder> xaResourceHolders = new ConcurrentHashMap<XAResource, Ehcache3XAResourceHolder>();
    private volatile transient RecoveryXAResourceHolder recoveryXAResourceHolder;

    Ehcache3XAResourceProducer() {
        this.setApplyTransactionTimeout(true);
    }

    void addXAResource(XAResource xaResource) {
        Ehcache3XAResourceHolder xaResourceHolder = new Ehcache3XAResourceHolder(xaResource, this);
        this.xaResourceHolders.put(xaResource, xaResourceHolder);
    }

    boolean removeXAResource(XAResource xaResource) {
        return this.xaResourceHolders.remove(xaResource) != null;
    }

    public XAResourceHolderState startRecovery() throws RecoveryException {
        if (this.recoveryXAResourceHolder != null) {
            throw new RecoveryException("recovery already in progress on " + (Object)((Object)this));
        }
        if (this.xaResourceHolders.isEmpty()) {
            throw new RecoveryException("no XAResource registered, recovery cannot be done on " + (Object)((Object)this));
        }
        this.recoveryXAResourceHolder = new RecoveryXAResourceHolder((XAResourceHolder)this.xaResourceHolders.values().iterator().next());
        return new XAResourceHolderState((XAResourceHolder)this.recoveryXAResourceHolder, (ResourceBean)this);
    }

    boolean isEmpty() {
        return this.xaResourceHolders.isEmpty();
    }

    public void endRecovery() {
        this.recoveryXAResourceHolder = null;
    }

    public void setFailed(boolean failed) {
    }

    public XAResourceHolder findXAResourceHolder(XAResource xaResource) {
        return (XAResourceHolder)this.xaResourceHolders.get(xaResource);
    }

    public void init() {
        try {
            ResourceRegistrar.register((XAResourceProducer)this);
        }
        catch (RecoveryException ex) {
            throw new BitronixRuntimeException("error recovering " + (Object)((Object)this), (Throwable)ex);
        }
    }

    public void close() {
        this.xaResourceHolders.clear();
        ResourceRegistrar.unregister((XAResourceProducer)this);
    }

    public XAStatefulHolder createPooledConnection(Object xaFactory, ResourceBean bean) {
        throw new UnsupportedOperationException("Ehcache is not connection-oriented");
    }

    public Reference getReference() {
        return new Reference(Ehcache3XAResourceProducer.class.getName(), new StringRefAddr("uniqueName", this.getUniqueName()), ResourceObjectFactory.class.getName(), null);
    }

    public String toString() {
        return "a Ehcache3XAResourceProducer with uniqueName " + this.getUniqueName();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.xaResourceHolders.clear();
        out.defaultWriteObject();
    }
}

