/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal.xml;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.core.util.ClassLoading;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.transactions.xa.internal.TypeUtil;
import org.ehcache.transactions.xa.txmgr.provider.LookupTransactionManagerProviderConfiguration;
import org.ehcache.transactions.xa.txmgr.provider.TransactionManagerProvider;
import org.ehcache.xml.BaseConfigParser;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class TxCacheManagerServiceConfigurationParser
extends BaseConfigParser<LookupTransactionManagerProviderConfiguration>
implements CacheManagerServiceConfigurationParser<TransactionManagerProvider> {
    private static final URI NAMESPACE = URI.create("http://www.ehcache.org/v3/tx");
    private static final URL XML_SCHEMA = TxCacheManagerServiceConfigurationParser.class.getResource("/ehcache-tx-ext.xsd");
    public static final String TRANSACTION_NAMESPACE_PREFIX = "tx:";
    private static final String TRANSACTION_ELEMENT_NAME = "jta-tm";
    private static final String TRANSACTION_LOOKUP_CLASS = "transaction-manager-lookup-class";

    public Source getXmlSchema() throws IOException {
        return new StreamSource(XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return NAMESPACE;
    }

    public ServiceCreationConfiguration<TransactionManagerProvider, ?> parseServiceCreationConfiguration(Element fragment, ClassLoader classLoader) {
        String localName = fragment.getLocalName();
        if (TRANSACTION_ELEMENT_NAME.equals(localName)) {
            String transactionManagerProviderConfigurationClassName = fragment.getAttribute(TRANSACTION_LOOKUP_CLASS);
            try {
                Class<?> aClass = Class.forName(transactionManagerProviderConfigurationClassName, true, ClassLoading.delegationChain(() -> Thread.currentThread().getContextClassLoader(), (ClassLoader[])new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader(), classLoader}));
                Class clazz = (Class)TypeUtil.uncheckedCast(aClass);
                return new LookupTransactionManagerProviderConfiguration(clazz);
            }
            catch (Exception e) {
                throw new XmlConfigurationException("Error configuring XA transaction manager", (Throwable)e);
            }
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public Class<TransactionManagerProvider> getServiceType() {
        return TransactionManagerProvider.class;
    }

    public Element unparseServiceCreationConfiguration(ServiceCreationConfiguration<TransactionManagerProvider, ?> serviceCreationConfiguration) {
        return this.unparseConfig(serviceCreationConfiguration);
    }

    protected Element createRootElement(Document doc, LookupTransactionManagerProviderConfiguration lookupTransactionManagerProviderConfiguration) {
        Element rootElement = doc.createElementNS(NAMESPACE.toString(), "tx:jta-tm");
        rootElement.setAttribute(TRANSACTION_LOOKUP_CLASS, lookupTransactionManagerProviderConfiguration.getTransactionManagerLookup().getName());
        return rootElement;
    }
}

