/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal.journal;

import org.ehcache.CachePersistenceException;
import org.ehcache.core.spi.service.DiskResourceService;
import org.ehcache.core.spi.service.FileBasedPersistenceContext;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.ehcache.transactions.xa.internal.journal.Journal;
import org.ehcache.transactions.xa.internal.journal.JournalProvider;
import org.ehcache.transactions.xa.internal.journal.PersistentJournal;
import org.ehcache.transactions.xa.internal.journal.TransientJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceDependencies(value={DiskResourceService.class})
public class DefaultJournalProvider
implements JournalProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJournalProvider.class);
    private volatile DiskResourceService diskResourceService;

    public void start(ServiceProvider<Service> serviceProvider) {
        this.diskResourceService = (DiskResourceService)serviceProvider.getService(DiskResourceService.class);
    }

    public void stop() {
        this.diskResourceService = null;
    }

    @Override
    public <K> Journal<K> getJournal(PersistableResourceService.PersistenceSpaceIdentifier<?> persistentSpaceId, Serializer<K> keySerializer) {
        if (persistentSpaceId == null) {
            LOGGER.info("Using transient XAStore journal");
            return new TransientJournal();
        }
        try {
            LOGGER.info("Using persistent XAStore journal");
            FileBasedPersistenceContext persistenceContext = this.diskResourceService.createPersistenceContextWithin(persistentSpaceId, "XAJournal");
            return new PersistentJournal<K>(persistenceContext.getDirectory(), keySerializer);
        }
        catch (CachePersistenceException cpe) {
            throw new RuntimeException(cpe);
        }
    }
}

