/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class SerializableXid
implements Xid,
Serializable {
    private final int formatId;
    private final byte[] globalTransactionId;
    private final byte[] branchQualifier;

    public SerializableXid(Xid xid) {
        if (xid.getGlobalTransactionId() == null) {
            throw new NullPointerException();
        }
        if (xid.getBranchQualifier() == null) {
            throw new NullPointerException();
        }
        this.formatId = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.branchQualifier = xid.getBranchQualifier();
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return Arrays.copyOf(this.branchQualifier, this.branchQualifier.length);
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return Arrays.copyOf(this.globalTransactionId, this.globalTransactionId.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializableXid that = (SerializableXid)o;
        if (this.formatId != that.formatId) {
            return false;
        }
        if (!Arrays.equals(this.globalTransactionId, that.globalTransactionId)) {
            return false;
        }
        return Arrays.equals(this.branchQualifier, that.branchQualifier);
    }

    public int hashCode() {
        int result = this.formatId;
        result = 31 * result + Arrays.hashCode(this.globalTransactionId);
        result = 31 * result + Arrays.hashCode(this.branchQualifier);
        return result;
    }

    public String toString() {
        return "SerializableXid{formatId=" + this.formatId + ", globalTxId=" + Arrays.toString(this.globalTransactionId) + ", branchQualifier=" + Arrays.toString(this.branchQualifier) + '}';
    }
}

