/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.ehcache.core.spi.store.AbstractValueHolder;
import org.ehcache.core.spi.store.Store;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.transactions.xa.internal.SoftLock;
import org.terracotta.offheapstore.util.FindbugsSuppressWarnings;

@FindbugsSuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR"})
public class XAValueHolder<V>
extends AbstractValueHolder<V>
implements Serializable {
    static final TimeUnit NATIVE_TIME_UNIT = TimeUnit.MILLISECONDS;
    private final V value;
    private final byte[] valueSerialized;

    public XAValueHolder(Store.ValueHolder<SoftLock<V>> valueHolder, V value) {
        super(-1L, valueHolder.creationTime(TimeUnit.MILLISECONDS), valueHolder.expirationTime(TimeUnit.MILLISECONDS));
        this.value = value;
        this.valueSerialized = null;
    }

    public XAValueHolder(V value, long creationTime) {
        super(-1L, creationTime, -1L);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        this.value = value;
        this.valueSerialized = null;
    }

    private XAValueHolder(XAValueHolder<V> valueHolder, ByteBuffer serializedValue) {
        super(-1L, valueHolder.creationTime(TimeUnit.MILLISECONDS), valueHolder.expirationTime(TimeUnit.MILLISECONDS));
        this.value = null;
        this.valueSerialized = new byte[serializedValue.remaining()];
        serializedValue.get(this.valueSerialized);
    }

    public XAValueHolder(XAValueHolder<V> valueHolder, V value) {
        super(-1L, valueHolder.creationTime(TimeUnit.MILLISECONDS), valueHolder.expirationTime(TimeUnit.MILLISECONDS));
        this.value = value;
        this.valueSerialized = null;
    }

    private XAValueHolder(long id, long creationTime, long lastAccessTime, long expirationTime, long hits, V value, byte[] valueSerialized) {
        super(id, creationTime, expirationTime);
        this.setLastAccessTime(lastAccessTime, NATIVE_TIME_UNIT);
        this.setHits(hits);
        this.value = value;
        this.valueSerialized = valueSerialized;
    }

    protected XAValueHolder<V> copyForSerialization(Serializer<V> valueSerializer) {
        ByteBuffer serializedValue = valueSerializer.serialize(this.value);
        return new XAValueHolder<ByteBuffer>((XAValueHolder<ByteBuffer>)this, serializedValue);
    }

    protected XAValueHolder<V> copyAfterDeserialization(Serializer<V> valueSerializer) throws ClassNotFoundException {
        return new XAValueHolder<Object>(this, valueSerializer.read(ByteBuffer.wrap(this.valueSerialized)));
    }

    protected TimeUnit nativeTimeUnit() {
        return NATIVE_TIME_UNIT;
    }

    public V get() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.value.hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        XAValueHolder that = (XAValueHolder)other;
        if (!super.equals((Object)that)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    private Object writeReplace() {
        return new SerializedXAValueHolder<V>(this.getId(), this.creationTime(NATIVE_TIME_UNIT), this.lastAccessTime(NATIVE_TIME_UNIT), this.expirationTime(NATIVE_TIME_UNIT), this.hits(), this.get(), this.valueSerialized);
    }

    private static class SerializedXAValueHolder<V>
    implements Serializable {
        private final long id;
        private final long creationTime;
        private final long lastAccessTime;
        private final long expirationTime;
        private final long hits;
        private final V value;
        private final byte[] valueSerialized;

        SerializedXAValueHolder(long id, long creationTime, long lastAccessTime, long expirationTime, long hits, V value, byte[] valueSerialized) {
            this.id = id;
            this.creationTime = creationTime;
            this.lastAccessTime = lastAccessTime;
            this.expirationTime = expirationTime;
            this.hits = hits;
            this.value = value;
            this.valueSerialized = valueSerialized;
        }

        private Object readResolve() {
            return new XAValueHolder(this.id, this.creationTime, this.lastAccessTime, this.expirationTime, this.hits, this.value, this.valueSerialized);
        }
    }
}

