/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ehcache.Cache;
import org.ehcache.ValueSupplier;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourceType;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.internal.store.StoreConfigurationImpl;
import org.ehcache.core.internal.store.StoreSupport;
import org.ehcache.core.internal.util.ValueSuppliers;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.function.NullaryFunction;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.copy.SerializingCopier;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.copy.CopyProvider;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.ehcache.transactions.xa.XACacheException;
import org.ehcache.transactions.xa.configuration.XAStoreConfiguration;
import org.ehcache.transactions.xa.internal.EhcacheXAResource;
import org.ehcache.transactions.xa.internal.SoftLock;
import org.ehcache.transactions.xa.internal.SoftLockSerializer;
import org.ehcache.transactions.xa.internal.SoftLockValueCombinedCopier;
import org.ehcache.transactions.xa.internal.SoftLockValueCombinedSerializer;
import org.ehcache.transactions.xa.internal.StoreEventSourceWrapper;
import org.ehcache.transactions.xa.internal.TransactionId;
import org.ehcache.transactions.xa.internal.XATransactionContext;
import org.ehcache.transactions.xa.internal.XATransactionContextFactory;
import org.ehcache.transactions.xa.internal.XAValueHolder;
import org.ehcache.transactions.xa.internal.commands.StoreEvictCommand;
import org.ehcache.transactions.xa.internal.commands.StorePutCommand;
import org.ehcache.transactions.xa.internal.commands.StoreRemoveCommand;
import org.ehcache.transactions.xa.internal.journal.Journal;
import org.ehcache.transactions.xa.internal.journal.JournalProvider;
import org.ehcache.transactions.xa.txmgr.TransactionManagerWrapper;
import org.ehcache.transactions.xa.txmgr.provider.TransactionManagerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.context.ContextManager;

public class XAStore<K, V>
implements Store<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAStore.class);
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Store<K, SoftLock<V>> underlyingStore;
    private final TransactionManagerWrapper transactionManagerWrapper;
    private final Map<Transaction, EhcacheXAResource<K, V>> xaResources = new ConcurrentHashMap<Transaction, EhcacheXAResource<K, V>>();
    private final TimeSource timeSource;
    private final Journal<K> journal;
    private final String uniqueXAResourceId;
    private final XATransactionContextFactory<K, V> transactionContextFactory;
    private final EhcacheXAResource recoveryXaResource;
    private final StoreEventSourceWrapper<K, V> eventSourceWrapper;
    private static final NullaryFunction<Boolean> REPLACE_EQUALS_TRUE = new NullaryFunction<Boolean>(){

        public Boolean apply() {
            return Boolean.TRUE;
        }
    };

    public XAStore(Class<K> keyType, Class<V> valueType, Store<K, SoftLock<V>> underlyingStore, TransactionManagerWrapper transactionManagerWrapper, TimeSource timeSource, Journal<K> journal, String uniqueXAResourceId) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.underlyingStore = underlyingStore;
        this.transactionManagerWrapper = transactionManagerWrapper;
        this.timeSource = timeSource;
        this.journal = journal;
        this.uniqueXAResourceId = uniqueXAResourceId;
        this.transactionContextFactory = new XATransactionContextFactory(timeSource);
        this.recoveryXaResource = new EhcacheXAResource<K, V>(underlyingStore, journal, this.transactionContextFactory);
        this.eventSourceWrapper = new StoreEventSourceWrapper(underlyingStore.getStoreEventSource());
        ContextManager.associate(underlyingStore).withParent((Object)this);
    }

    private static boolean isInDoubt(SoftLock<?> softLock) {
        return softLock.getTransactionId() != null;
    }

    private Store.ValueHolder<SoftLock<V>> getSoftLockValueHolderFromUnderlyingStore(K key) throws StoreAccessException {
        return this.underlyingStore.get(key);
    }

    private XATransactionContext<K, V> getCurrentContext() {
        try {
            XATransactionContext<K, V> currentContext;
            final Transaction transaction = this.transactionManagerWrapper.getTransactionManager().getTransaction();
            if (transaction == null) {
                throw new XACacheException("Cannot access XA cache outside of XA transaction scope");
            }
            EhcacheXAResource<K, V> xaResource = this.xaResources.get(transaction);
            if (xaResource == null) {
                xaResource = new EhcacheXAResource<K, V>(this.underlyingStore, this.journal, this.transactionContextFactory);
                this.transactionManagerWrapper.registerXAResource(this.uniqueXAResourceId, xaResource);
                this.transactionManagerWrapper.getTransactionManager().getTransaction().enlistResource(xaResource);
                this.xaResources.put(transaction, xaResource);
                final EhcacheXAResource<K, V> finalXaResource = xaResource;
                transaction.registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int status) {
                        XAStore.this.transactionManagerWrapper.unregisterXAResource(XAStore.this.uniqueXAResourceId, finalXaResource);
                        XAStore.this.xaResources.remove(transaction);
                    }
                });
            }
            if ((currentContext = xaResource.getCurrentContext()).hasTimedOut()) {
                throw new XACacheException("Current XA transaction has timed out");
            }
            return currentContext;
        }
        catch (SystemException se) {
            throw new XACacheException("Cannot get current XA transaction", se);
        }
        catch (RollbackException re) {
            throw new XACacheException("XA Transaction has been marked for rollback only", re);
        }
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private void checkKey(K keyObject) {
        if (keyObject == null) {
            throw new NullPointerException();
        }
        if (!this.keyType.isAssignableFrom(keyObject.getClass())) {
            throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
        }
    }

    private void checkValue(V valueObject) {
        if (valueObject == null) {
            throw new NullPointerException();
        }
        if (!this.valueType.isAssignableFrom(valueObject.getClass())) {
            throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
        }
    }

    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        this.checkKey(key);
        XATransactionContext currentContext = this.getCurrentContext();
        if (currentContext.removed(key)) {
            return null;
        }
        XAValueHolder<V> newValueHolder = currentContext.newValueHolderOf(key);
        if (newValueHolder != null) {
            return newValueHolder;
        }
        Store.ValueHolder<SoftLock<V>> softLockValueHolder = this.getSoftLockValueHolderFromUnderlyingStore(key);
        if (softLockValueHolder == null) {
            return null;
        }
        SoftLock softLock = (SoftLock)softLockValueHolder.value();
        if (XAStore.isInDoubt(softLock)) {
            currentContext.addCommand(key, new StoreEvictCommand(softLock.getOldValue()));
            return null;
        }
        return new XAValueHolder<V>(softLockValueHolder, softLock.getOldValue());
    }

    public boolean containsKey(K key) throws StoreAccessException {
        this.checkKey(key);
        if (this.getCurrentContext().touched(key)) {
            return this.getCurrentContext().newValueHolderOf(key) != null;
        }
        Store.ValueHolder<SoftLock<V>> softLockValueHolder = this.getSoftLockValueHolderFromUnderlyingStore(key);
        return softLockValueHolder != null && ((SoftLock)softLockValueHolder.value()).getTransactionId() == null && ((SoftLock)softLockValueHolder.value()).getOldValue() != null;
    }

    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        XATransactionContext currentContext = this.getCurrentContext();
        if (currentContext.touched(key)) {
            V oldValue = currentContext.oldValueOf(key);
            V newValue = currentContext.newValueOf(key);
            currentContext.addCommand(key, new StorePutCommand<V>(oldValue, new XAValueHolder<V>(value, this.timeSource.getTimeMillis())));
            return newValue == null ? Store.PutStatus.PUT : Store.PutStatus.UPDATE;
        }
        Store.ValueHolder<SoftLock<V>> softLockValueHolder = this.getSoftLockValueHolderFromUnderlyingStore(key);
        Store.PutStatus status = Store.PutStatus.NOOP;
        if (softLockValueHolder != null) {
            SoftLock softLock = (SoftLock)softLockValueHolder.value();
            if (XAStore.isInDoubt(softLock)) {
                currentContext.addCommand(key, new StoreEvictCommand(softLock.getOldValue()));
            } else if (currentContext.addCommand(key, new StorePutCommand(softLock.getOldValue(), new XAValueHolder<V>(value, this.timeSource.getTimeMillis())))) {
                status = Store.PutStatus.UPDATE;
            }
        } else if (currentContext.addCommand(key, new StorePutCommand<Object>(null, new XAValueHolder<V>(value, this.timeSource.getTimeMillis())))) {
            status = Store.PutStatus.PUT;
        }
        return status;
    }

    public boolean remove(K key) throws StoreAccessException {
        this.checkKey(key);
        XATransactionContext currentContext = this.getCurrentContext();
        if (currentContext.touched(key)) {
            V oldValue = currentContext.oldValueOf(key);
            V newValue = currentContext.newValueOf(key);
            currentContext.addCommand(key, new StoreRemoveCommand<V>(oldValue));
            return newValue != null;
        }
        Store.ValueHolder<SoftLock<V>> softLockValueHolder = this.getSoftLockValueHolderFromUnderlyingStore(key);
        boolean status = false;
        if (softLockValueHolder != null) {
            SoftLock softLock = (SoftLock)softLockValueHolder.value();
            if (XAStore.isInDoubt(softLock)) {
                currentContext.addCommand(key, new StoreEvictCommand(softLock.getOldValue()));
            } else {
                status = currentContext.addCommand(key, new StoreRemoveCommand(softLock.getOldValue()));
            }
        }
        return status;
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        XATransactionContext currentContext = this.getCurrentContext();
        if (currentContext.touched(key)) {
            V oldValue = currentContext.oldValueOf(key);
            V newValue = currentContext.newValueOf(key);
            if (newValue == null) {
                currentContext.addCommand(key, new StorePutCommand<V>(oldValue, new XAValueHolder<V>(value, this.timeSource.getTimeMillis())));
                return null;
            }
            return currentContext.newValueHolderOf(key);
        }
        Store.ValueHolder<SoftLock<V>> softLockValueHolder = this.getSoftLockValueHolderFromUnderlyingStore(key);
        if (softLockValueHolder != null) {
            SoftLock softLock = (SoftLock)softLockValueHolder.value();
            if (XAStore.isInDoubt(softLock)) {
                currentContext.addCommand(key, new StoreEvictCommand(softLock.getOldValue()));
                return null;
            }
            return new XAValueHolder<V>(softLockValueHolder, softLock.getOldValue());
        }
        currentContext.addCommand(key, new StorePutCommand<Object>(null, new XAValueHolder<V>(value, this.timeSource.getTimeMillis())));
        return null;
    }

    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        XATransactionContext currentContext = this.getCurrentContext();
        if (currentContext.touched(key)) {
            V oldValue = currentContext.oldValueOf(key);
            V newValue = currentContext.newValueOf(key);
            if (newValue == null) {
                return Store.RemoveStatus.KEY_MISSING;
            }
            if (!newValue.equals(value)) {
                return Store.RemoveStatus.KEY_PRESENT;
            }
            currentContext.addCommand(key, new StoreRemoveCommand<V>(oldValue));
            return Store.RemoveStatus.REMOVED;
        }
        Store.ValueHolder<SoftLock<V>> softLockValueHolder = this.getSoftLockValueHolderFromUnderlyingStore(key);
        if (softLockValueHolder != null) {
            SoftLock softLock = (SoftLock)softLockValueHolder.value();
            if (XAStore.isInDoubt(softLock)) {
                currentContext.addCommand(key, new StoreEvictCommand(softLock.getOldValue()));
                return Store.RemoveStatus.KEY_MISSING;
            }
            if (!softLock.getOldValue().equals(value)) {
                return Store.RemoveStatus.KEY_PRESENT;
            }
            currentContext.addCommand(key, new StoreRemoveCommand(softLock.getOldValue()));
            return Store.RemoveStatus.REMOVED;
        }
        return Store.RemoveStatus.KEY_MISSING;
    }

    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        XATransactionContext currentContext = this.getCurrentContext();
        if (currentContext.touched(key)) {
            V newValue = currentContext.newValueOf(key);
            if (newValue == null) {
                return null;
            }
            V oldValue = currentContext.oldValueOf(key);
            XAValueHolder<V> newValueHolder = currentContext.newValueHolderOf(key);
            currentContext.addCommand(key, new StorePutCommand<V>(oldValue, new XAValueHolder<V>(value, this.timeSource.getTimeMillis())));
            return newValueHolder;
        }
        Store.ValueHolder<SoftLock<V>> softLockValueHolder = this.getSoftLockValueHolderFromUnderlyingStore(key);
        if (softLockValueHolder != null) {
            SoftLock softLock = (SoftLock)softLockValueHolder.value();
            if (XAStore.isInDoubt(softLock)) {
                currentContext.addCommand(key, new StoreEvictCommand(softLock.getOldValue()));
                return null;
            }
            Object oldValue = softLock.getOldValue();
            currentContext.addCommand(key, new StorePutCommand(oldValue, new XAValueHolder<V>(value, this.timeSource.getTimeMillis())));
            return new XAValueHolder(oldValue, softLockValueHolder.creationTime(XAValueHolder.NATIVE_TIME_UNIT));
        }
        return null;
    }

    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        XATransactionContext currentContext = this.getCurrentContext();
        if (currentContext.touched(key)) {
            V modifiedValue = currentContext.newValueOf(key);
            if (modifiedValue == null) {
                return Store.ReplaceStatus.MISS_NOT_PRESENT;
            }
            if (!modifiedValue.equals(oldValue)) {
                return Store.ReplaceStatus.MISS_PRESENT;
            }
            V previousValue = currentContext.oldValueOf(key);
            currentContext.addCommand(key, new StorePutCommand<V>(previousValue, new XAValueHolder<V>(newValue, this.timeSource.getTimeMillis())));
            return Store.ReplaceStatus.HIT;
        }
        Store.ValueHolder<SoftLock<V>> softLockValueHolder = this.getSoftLockValueHolderFromUnderlyingStore(key);
        if (softLockValueHolder != null) {
            SoftLock softLock = (SoftLock)softLockValueHolder.value();
            Object previousValue = softLock.getOldValue();
            if (XAStore.isInDoubt(softLock)) {
                currentContext.addCommand(key, new StoreEvictCommand(previousValue));
                return Store.ReplaceStatus.MISS_NOT_PRESENT;
            }
            if (!previousValue.equals(oldValue)) {
                return Store.ReplaceStatus.MISS_PRESENT;
            }
            currentContext.addCommand(key, new StorePutCommand(previousValue, new XAValueHolder<V>(newValue, this.timeSource.getTimeMillis())));
            return Store.ReplaceStatus.HIT;
        }
        return Store.ReplaceStatus.MISS_NOT_PRESENT;
    }

    public void clear() throws StoreAccessException {
        this.underlyingStore.clear();
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return this.eventSourceWrapper;
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        XATransactionContext<K, V> currentContext = this.getCurrentContext();
        Map<K, XAValueHolder<V>> valueHolderMap = this.transactionContextFactory.listPuts(currentContext.getTransactionId());
        return new XAIterator(valueHolderMap, this.underlyingStore.iterator(), currentContext.getTransactionId());
    }

    /*
     * Exception decompiling
     */
    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        return this.compute(key, mappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        XAValueHolder<Object> xaValueHolder;
        this.checkKey(key);
        XATransactionContext currentContext = this.getCurrentContext();
        if (currentContext.removed(key)) {
            return this.updateCommandForKey(key, mappingFunction, currentContext);
        }
        if (currentContext.evicted(key)) {
            return new XAValueHolder<V>(currentContext.oldValueOf(key), this.timeSource.getTimeMillis());
        }
        boolean updated = currentContext.touched(key);
        Store.ValueHolder<SoftLock<V>> softLockValueHolder = this.getSoftLockValueHolderFromUnderlyingStore(key);
        if (softLockValueHolder == null) {
            if (updated) {
                xaValueHolder = currentContext.newValueHolderOf(key);
            } else {
                Object computed = mappingFunction.apply(key);
                if (computed != null) {
                    xaValueHolder = new XAValueHolder<Object>(computed, this.timeSource.getTimeMillis());
                    currentContext.addCommand(key, new StorePutCommand<Object>(null, xaValueHolder));
                } else {
                    xaValueHolder = null;
                }
            }
        } else if (XAStore.isInDoubt((SoftLock)softLockValueHolder.value())) {
            currentContext.addCommand(key, new StoreEvictCommand(((SoftLock)softLockValueHolder.value()).getOldValue()));
            xaValueHolder = new XAValueHolder<V>(softLockValueHolder, ((SoftLock)softLockValueHolder.value()).getNewValueHolder().value());
        } else {
            xaValueHolder = updated ? currentContext.newValueHolderOf(key) : new XAValueHolder<V>(softLockValueHolder, ((SoftLock)softLockValueHolder.value()).getOldValue());
        }
        return xaValueHolder;
    }

    private Store.ValueHolder<V> updateCommandForKey(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, NullaryFunction<Boolean> replaceEqual, XATransactionContext<K, V> currentContext) {
        Object newValue = mappingFunction.apply(key, currentContext.newValueOf(key));
        XAValueHolder<Object> xaValueHolder = null;
        V oldValue = currentContext.oldValueOf(key);
        if (newValue == null) {
            if (oldValue != null || ((Boolean)replaceEqual.apply()).booleanValue()) {
                currentContext.addCommand(key, new StoreRemoveCommand<V>(oldValue));
            } else {
                currentContext.removeCommand(key);
            }
        } else {
            this.checkValue(newValue);
            xaValueHolder = new XAValueHolder<Object>(newValue, this.timeSource.getTimeMillis());
            if (!XAStore.eq(oldValue, newValue) || ((Boolean)replaceEqual.apply()).booleanValue()) {
                currentContext.addCommand(key, new StorePutCommand<Object>(oldValue, xaValueHolder));
            }
        }
        return xaValueHolder;
    }

    private Store.ValueHolder<V> updateCommandForKey(K key, Function<? super K, ? extends V> mappingFunction, XATransactionContext<K, V> currentContext) {
        Object computed = mappingFunction.apply(key);
        XAValueHolder<Object> xaValueHolder = null;
        if (computed != null) {
            this.checkValue(computed);
            xaValueHolder = new XAValueHolder<Object>(computed, this.timeSource.getTimeMillis());
            V oldValue = currentContext.oldValueOf(key);
            currentContext.addCommand(key, new StorePutCommand<Object>(oldValue, xaValueHolder));
        }
        return xaValueHolder;
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, final Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            Store.ValueHolder<V> newValue = this.compute(key, new BiFunction<K, V, V>(){

                public V apply(K k, V oldValue) {
                    Set entrySet = Collections.singletonMap(k, oldValue).entrySet();
                    Iterable entries = (Iterable)remappingFunction.apply(entrySet);
                    Iterator iterator = entries.iterator();
                    Map.Entry next = (Map.Entry)iterator.next();
                    Object key = next.getKey();
                    Object value = next.getValue();
                    XAStore.this.checkKey(key);
                    if (value != null) {
                        XAStore.this.checkValue(value);
                    }
                    return value;
                }
            }, replaceEqual);
            result.put(key, newValue);
        }
        return result;
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, final Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            Store.ValueHolder<V> newValue = this.computeIfAbsent(key, new Function<K, V>(){

                public V apply(K k) {
                    Set keySet = Collections.singleton(k);
                    Iterable entries = (Iterable)mappingFunction.apply(keySet);
                    Iterator iterator = entries.iterator();
                    Map.Entry next = (Map.Entry)iterator.next();
                    Object computedKey = next.getKey();
                    Object computedValue = next.getValue();
                    XAStore.this.checkKey(computedKey);
                    if (computedValue == null) {
                        return null;
                    }
                    XAStore.this.checkValue(computedValue);
                    return computedValue;
                }
            });
            result.put(key, newValue);
        }
        return result;
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return this.underlyingStore.getConfigurationChangeListeners();
    }

    private static class XAEvictionAdvisor<K, V>
    implements EvictionAdvisor<K, SoftLock<V>> {
        private final EvictionAdvisor<? super K, ? super V> wrappedEvictionAdvisor;

        private XAEvictionAdvisor(EvictionAdvisor<? super K, ? super V> wrappedEvictionAdvisor) {
            this.wrappedEvictionAdvisor = wrappedEvictionAdvisor;
        }

        public boolean adviseAgainstEviction(K key, SoftLock<V> softLock) {
            return XAStore.isInDoubt(softLock) || this.wrappedEvictionAdvisor.adviseAgainstEviction(key, softLock.getOldValue());
        }
    }

    @ServiceDependencies(value={TimeSourceService.class, JournalProvider.class, CopyProvider.class, TransactionManagerProvider.class})
    public static class Provider
    implements Store.Provider {
        private volatile ServiceProvider<Service> serviceProvider;
        private volatile TransactionManagerProvider transactionManagerProvider;
        private final Map<Store<?, ?>, CreatedStoreRef> createdStores = new ConcurrentWeakIdentityHashMap();

        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            XAStoreConfiguration xaServiceConfiguration = (XAStoreConfiguration)ServiceUtils.findSingletonAmongst(XAStoreConfiguration.class, serviceConfigs);
            if (xaServiceConfiguration == null) {
                return 0;
            }
            if (this.transactionManagerProvider == null) {
                throw new IllegalStateException("A TransactionManagerProvider is mandatory to use XA caches");
            }
            Store.Provider candidateUnderlyingProvider = this.selectProvider(resourceTypes, serviceConfigs, xaServiceConfiguration);
            return 1000 + candidateUnderlyingProvider.rank(resourceTypes, serviceConfigs);
        }

        public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            EnumSet<ResourceType.Core> supportedTypes = EnumSet.allOf(ResourceType.Core.class);
            Set configuredTypes = storeConfig.getResourcePools().getResourceTypeSet();
            for (ResourceType type : configuredTypes) {
                if (supportedTypes.contains(type)) continue;
                throw new IllegalStateException("Unsupported resource type : " + type.getResourcePoolClass());
            }
            XAStoreConfiguration xaServiceConfiguration = (XAStoreConfiguration)ServiceUtils.findSingletonAmongst(XAStoreConfiguration.class, (Object[])serviceConfigs);
            if (xaServiceConfiguration == null) {
                throw new IllegalStateException("XAStore.Provider.createStore called without XAStoreConfiguration");
            }
            Store.Provider underlyingStoreProvider = this.selectProvider(configuredTypes, Arrays.asList(serviceConfigs), xaServiceConfiguration);
            String uniqueXAResourceId = xaServiceConfiguration.getUniqueXAResourceId();
            ArrayList<Object> underlyingServiceConfigs = new ArrayList<Object>();
            underlyingServiceConfigs.addAll(Arrays.asList(serviceConfigs));
            EvictionAdvisor realEvictionAdvisor = storeConfig.getEvictionAdvisor();
            XAEvictionAdvisor evictionAdvisor = realEvictionAdvisor == null ? null : new XAEvictionAdvisor(realEvictionAdvisor);
            final Expiry configuredExpiry = storeConfig.getExpiry();
            Expiry expiry = new Expiry<K, SoftLock<V>>(){

                public Duration getExpiryForCreation(K key, SoftLock<V> softLock) {
                    Duration duration;
                    if (softLock.getTransactionId() != null) {
                        return Duration.INFINITE;
                    }
                    try {
                        duration = configuredExpiry.getExpiryForCreation(key, softLock.getOldValue());
                    }
                    catch (RuntimeException re) {
                        LOGGER.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
                        return Duration.ZERO;
                    }
                    return duration;
                }

                public Duration getExpiryForAccess(K key, ValueSupplier<? extends SoftLock<V>> softLock) {
                    Duration duration;
                    if (((SoftLock)softLock.value()).getTransactionId() != null) {
                        return Duration.INFINITE;
                    }
                    try {
                        duration = configuredExpiry.getExpiryForAccess(key, ValueSuppliers.supplierOf(((SoftLock)softLock.value()).getOldValue()));
                    }
                    catch (RuntimeException re) {
                        LOGGER.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
                        return Duration.ZERO;
                    }
                    return duration;
                }

                public Duration getExpiryForUpdate(K key, ValueSupplier<? extends SoftLock<V>> oldSoftLockSupplier, SoftLock<V> newSoftLock) {
                    Duration duration;
                    SoftLock oldSoftLock = (SoftLock)oldSoftLockSupplier.value();
                    if (oldSoftLock.getTransactionId() == null) {
                        return Duration.INFINITE;
                    }
                    if (oldSoftLock.getOldValue() == null) {
                        Duration duration2;
                        try {
                            duration2 = configuredExpiry.getExpiryForCreation(key, oldSoftLock.getOldValue());
                        }
                        catch (RuntimeException re) {
                            LOGGER.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
                            return Duration.ZERO;
                        }
                        return duration2;
                    }
                    Object value = oldSoftLock.getNewValueHolder() == null ? null : oldSoftLock.getNewValueHolder().value();
                    try {
                        duration = configuredExpiry.getExpiryForUpdate(key, ValueSuppliers.supplierOf(oldSoftLock.getOldValue()), value);
                    }
                    catch (RuntimeException re) {
                        LOGGER.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
                        return Duration.ZERO;
                    }
                    return duration;
                }
            };
            PersistableResourceService.PersistenceSpaceIdentifier persistenceSpaceId = (PersistableResourceService.PersistenceSpaceIdentifier)ServiceUtils.findSingletonAmongst(PersistableResourceService.PersistenceSpaceIdentifier.class, (Object[])serviceConfigs);
            Collection copierConfigs = ServiceUtils.findAmongst(DefaultCopierConfiguration.class, underlyingServiceConfigs);
            DefaultCopierConfiguration keyCopierConfig = null;
            DefaultCopierConfiguration valueCopierConfig = null;
            for (DefaultCopierConfiguration copierConfig : copierConfigs) {
                if (copierConfig.getType().equals((Object)DefaultCopierConfiguration.Type.KEY)) {
                    keyCopierConfig = copierConfig;
                } else if (copierConfig.getType().equals((Object)DefaultCopierConfiguration.Type.VALUE)) {
                    valueCopierConfig = copierConfig;
                }
                underlyingServiceConfigs.remove(copierConfig);
            }
            if (keyCopierConfig == null) {
                underlyingServiceConfigs.add(new DefaultCopierConfiguration(SerializingCopier.asCopierClass(), DefaultCopierConfiguration.Type.KEY));
            } else {
                underlyingServiceConfigs.add(keyCopierConfig);
            }
            if (valueCopierConfig == null) {
                underlyingServiceConfigs.add(new DefaultCopierConfiguration(SerializingCopier.asCopierClass(), DefaultCopierConfiguration.Type.VALUE));
            } else {
                CopyProvider copyProvider = (CopyProvider)this.serviceProvider.getService(CopyProvider.class);
                Copier valueCopier = copyProvider.createValueCopier(storeConfig.getValueType(), storeConfig.getValueSerializer(), new ServiceConfiguration[]{valueCopierConfig});
                SoftLockValueCombinedCopier softLockValueCombinedCopier = new SoftLockValueCombinedCopier(valueCopier);
                underlyingServiceConfigs.add(new DefaultCopierConfiguration(softLockValueCombinedCopier, DefaultCopierConfiguration.Type.VALUE));
            }
            Journal journal = ((JournalProvider)this.serviceProvider.getService(JournalProvider.class)).getJournal(persistenceSpaceId, storeConfig.getKeySerializer());
            TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
            AtomicReference softLockSerializerRef = new AtomicReference();
            SoftLockValueCombinedSerializer softLockValueCombinedSerializer = new SoftLockValueCombinedSerializer(softLockSerializerRef, storeConfig.getValueSerializer());
            Class<SoftLock> softLockClass = SoftLock.class;
            StoreConfigurationImpl underlyingStoreConfig = new StoreConfigurationImpl(storeConfig.getKeyType(), softLockClass, evictionAdvisor, storeConfig.getClassLoader(), expiry, storeConfig.getResourcePools(), storeConfig.getDispatcherConcurrency(), storeConfig.getKeySerializer(), softLockValueCombinedSerializer);
            Store underlyingStore = underlyingStoreProvider.createStore((Store.Configuration)underlyingStoreConfig, underlyingServiceConfigs.toArray(new ServiceConfiguration[0]));
            TransactionManagerWrapper transactionManagerWrapper = this.transactionManagerProvider.getTransactionManagerWrapper();
            XAStore store = new XAStore(storeConfig.getKeyType(), storeConfig.getValueType(), underlyingStore, transactionManagerWrapper, timeSource, journal, uniqueXAResourceId);
            SoftLockValueCombinedSerializerLifecycleHelper helper = new SoftLockValueCombinedSerializerLifecycleHelper(softLockSerializerRef, storeConfig.getClassLoader());
            this.createdStores.put(store, new CreatedStoreRef(underlyingStoreProvider, helper));
            return store;
        }

        public void releaseStore(Store<?, ?> resource) {
            CreatedStoreRef createdStoreRef = this.createdStores.remove(resource);
            if (createdStoreRef == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            Store.Provider underlyingStoreProvider = createdStoreRef.storeProvider;
            SoftLockValueCombinedSerializerLifecycleHelper helper = createdStoreRef.lifecycleHelper;
            if (resource instanceof XAStore) {
                XAStore xaStore = (XAStore)resource;
                xaStore.transactionManagerWrapper.unregisterXAResource(xaStore.uniqueXAResourceId, xaStore.recoveryXaResource);
                underlyingStoreProvider.releaseStore(xaStore.underlyingStore);
                helper.softLockSerializerRef.set(null);
                try {
                    xaStore.journal.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            } else {
                underlyingStoreProvider.releaseStore(resource);
            }
        }

        public void initStore(Store<?, ?> resource) {
            CreatedStoreRef createdStoreRef = this.createdStores.get(resource);
            if (createdStoreRef == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            Store.Provider underlyingStoreProvider = createdStoreRef.storeProvider;
            SoftLockValueCombinedSerializerLifecycleHelper helper = createdStoreRef.lifecycleHelper;
            if (resource instanceof XAStore) {
                XAStore xaStore = (XAStore)resource;
                underlyingStoreProvider.initStore(xaStore.underlyingStore);
                helper.softLockSerializerRef.set(new SoftLockSerializer(helper.classLoader));
                try {
                    xaStore.journal.open();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                xaStore.transactionManagerWrapper.registerXAResource(xaStore.uniqueXAResourceId, xaStore.recoveryXaResource);
            } else {
                underlyingStoreProvider.initStore(resource);
            }
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
            this.transactionManagerProvider = (TransactionManagerProvider)serviceProvider.getService(TransactionManagerProvider.class);
        }

        public void stop() {
            this.transactionManagerProvider = null;
            this.serviceProvider = null;
        }

        private Store.Provider selectProvider(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs, XAStoreConfiguration xaConfig) {
            ArrayList configsWithoutXA = new ArrayList(serviceConfigs);
            configsWithoutXA.remove(xaConfig);
            return StoreSupport.selectStoreProvider(this.serviceProvider, resourceTypes, configsWithoutXA);
        }
    }

    private static final class CreatedStoreRef {
        final Store.Provider storeProvider;
        final SoftLockValueCombinedSerializerLifecycleHelper lifecycleHelper;

        public CreatedStoreRef(Store.Provider storeProvider, SoftLockValueCombinedSerializerLifecycleHelper lifecycleHelper) {
            this.storeProvider = storeProvider;
            this.lifecycleHelper = lifecycleHelper;
        }
    }

    private static final class SoftLockValueCombinedSerializerLifecycleHelper<T> {
        final AtomicReference<SoftLockSerializer<T>> softLockSerializerRef;
        final ClassLoader classLoader;

        SoftLockValueCombinedSerializerLifecycleHelper(AtomicReference<SoftLockSerializer<T>> softLockSerializerRef, ClassLoader classLoader) {
            this.softLockSerializerRef = softLockSerializerRef;
            this.classLoader = classLoader;
        }
    }

    class XAIterator
    implements Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> {
        private final Iterator<Map.Entry<K, XAValueHolder<V>>> iterator;
        private final Store.Iterator<Cache.Entry<K, Store.ValueHolder<SoftLock<V>>>> underlyingIterator;
        private final TransactionId transactionId;
        private Cache.Entry<K, Store.ValueHolder<V>> next;
        private StoreAccessException prefetchFailure = null;

        XAIterator(Map<K, XAValueHolder<V>> valueHolderMap, Store.Iterator<Cache.Entry<K, Store.ValueHolder<SoftLock<V>>>> underlyingIterator, TransactionId transactionId) {
            this.transactionId = transactionId;
            this.iterator = valueHolderMap.entrySet().iterator();
            this.underlyingIterator = underlyingIterator;
            this.advance();
        }

        void advance() {
            this.next = null;
            if (this.iterator.hasNext()) {
                final Map.Entry entry = this.iterator.next();
                this.next = new Cache.Entry<K, Store.ValueHolder<V>>(){

                    public K getKey() {
                        return entry.getKey();
                    }

                    public Store.ValueHolder<V> getValue() {
                        return (Store.ValueHolder)entry.getValue();
                    }
                };
                return;
            }
            while (this.underlyingIterator.hasNext()) {
                XAValueHolder xaValueHolder;
                Cache.Entry next;
                try {
                    next = (Cache.Entry)this.underlyingIterator.next();
                }
                catch (StoreAccessException e) {
                    this.prefetchFailure = e;
                    break;
                }
                if (XAStore.this.transactionContextFactory.isTouched(this.transactionId, next.getKey())) continue;
                Store.ValueHolder valueHolder = (Store.ValueHolder)next.getValue();
                SoftLock softLock = (SoftLock)valueHolder.value();
                if (softLock.getTransactionId() == this.transactionId) {
                    xaValueHolder = new XAValueHolder(valueHolder, softLock.getNewValueHolder().value());
                } else {
                    if (XAStore.isInDoubt(softLock)) continue;
                    xaValueHolder = new XAValueHolder(valueHolder, softLock.getOldValue());
                }
                this.next = new Cache.Entry<K, Store.ValueHolder<V>>(){

                    public K getKey() {
                        return next.getKey();
                    }

                    public Store.ValueHolder<V> getValue() {
                        return xaValueHolder;
                    }
                };
                break;
            }
        }

        public boolean hasNext() {
            if (!XAStore.this.getCurrentContext().getTransactionId().equals(this.transactionId)) {
                throw new IllegalStateException("Iterator has been created in another transaction, it can only be used in the transaction it has been created in.");
            }
            return this.next != null | this.prefetchFailure != null;
        }

        public Cache.Entry<K, Store.ValueHolder<V>> next() throws StoreAccessException {
            if (this.prefetchFailure != null) {
                throw this.prefetchFailure;
            }
            if (!XAStore.this.getCurrentContext().getTransactionId().equals(this.transactionId)) {
                throw new IllegalStateException("Iterator has been created in another transaction, it can only be used in the transaction it has been created in.");
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Cache.Entry rc = this.next;
            this.advance();
            return rc;
        }
    }
}

