/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;
import org.ehcache.transactions.xa.internal.SoftLock;

class SoftLockValueCombinedSerializer<T>
implements Serializer<SoftLock<T>> {
    private final AtomicReference<? extends Serializer<SoftLock<T>>> softLockSerializerRef;
    private final Serializer<T> valueSerializer;

    SoftLockValueCombinedSerializer(AtomicReference<? extends Serializer<SoftLock<T>>> softLockSerializerRef, Serializer<T> valueSerializer) {
        this.softLockSerializerRef = softLockSerializerRef;
        this.valueSerializer = valueSerializer;
    }

    public ByteBuffer serialize(SoftLock<T> softLock) throws SerializerException {
        return this.softLockSerializerRef.get().serialize(softLock.copyForSerialization(this.valueSerializer));
    }

    public SoftLock<T> read(ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        SoftLock serializedSoftLock = (SoftLock)this.softLockSerializerRef.get().read(binary);
        return serializedSoftLock.copyAfterDeserialization(this.valueSerializer, serializedSoftLock);
    }

    public boolean equals(SoftLock<T> object, ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        return object.equals(this.read(binary));
    }
}

