/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.transactions.xa.internal.TransactionId;
import org.ehcache.transactions.xa.internal.XAValueHolder;

public class SoftLock<V>
implements Serializable {
    private final TransactionId transactionId;
    private final V oldValue;
    private final byte[] oldValueSerialized;
    private final XAValueHolder<V> newValueHolder;

    public SoftLock(TransactionId transactionId, V oldValue, XAValueHolder<V> newValueHolder) {
        this.transactionId = transactionId;
        this.oldValue = oldValue;
        this.oldValueSerialized = null;
        this.newValueHolder = newValueHolder;
    }

    private SoftLock(TransactionId transactionId, ByteBuffer serializedOldValue, XAValueHolder<V> serializedNewValueHolder) {
        this.transactionId = transactionId;
        this.oldValue = null;
        if (serializedOldValue != null) {
            this.oldValueSerialized = new byte[serializedOldValue.remaining()];
            serializedOldValue.get(this.oldValueSerialized);
        } else {
            this.oldValueSerialized = null;
        }
        this.newValueHolder = serializedNewValueHolder;
    }

    protected SoftLock<V> copyForSerialization(Serializer<V> valueSerializer) {
        ByteBuffer serializedOldValue = null;
        if (this.oldValue != null) {
            serializedOldValue = valueSerializer.serialize(this.oldValue);
        }
        XAValueHolder<V> serializedXaValueHolder = null;
        if (this.newValueHolder != null) {
            serializedXaValueHolder = this.newValueHolder.copyForSerialization(valueSerializer);
        }
        return new SoftLock<V>(this.transactionId, serializedOldValue, serializedXaValueHolder);
    }

    protected SoftLock<V> copyAfterDeserialization(Serializer<V> valueSerializer, SoftLock<V> serializedSoftLock) throws ClassNotFoundException {
        Object oldValue = null;
        if (serializedSoftLock.oldValueSerialized != null) {
            oldValue = valueSerializer.read(ByteBuffer.wrap(serializedSoftLock.oldValueSerialized));
        }
        XAValueHolder<V> newValueHolder = null;
        if (this.newValueHolder != null) {
            newValueHolder = this.newValueHolder.copyAfterDeserialization(valueSerializer);
        }
        return new SoftLock<Object>(this.transactionId, oldValue, newValueHolder);
    }

    public V getOldValue() {
        return this.oldValue;
    }

    public XAValueHolder<V> getNewValueHolder() {
        return this.newValueHolder;
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoftLock softLock = (SoftLock)o;
        if (this.transactionId != null ? !this.transactionId.equals(softLock.transactionId) : softLock.transactionId != null) {
            return false;
        }
        if (this.oldValue != null ? !this.oldValue.equals(softLock.oldValue) : softLock.oldValue != null) {
            return false;
        }
        return !(this.newValueHolder == null ? softLock.newValueHolder != null : !this.newValueHolder.equals(softLock.newValueHolder));
    }

    public int hashCode() {
        int result = this.transactionId != null ? this.transactionId.hashCode() : 0;
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.newValueHolder != null ? this.newValueHolder.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SoftLock TxId[" + this.transactionId + "] Old[" + this.oldValue + "] New[" + this.newValueHolder + "]";
    }
}

