/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal.journal;

import org.ehcache.CachePersistenceException;
import org.ehcache.core.spi.service.FileBasedPersistenceContext;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceProvider;
import org.ehcache.transactions.xa.internal.journal.Journal;
import org.ehcache.transactions.xa.internal.journal.JournalProvider;
import org.ehcache.transactions.xa.internal.journal.PersistentJournal;
import org.ehcache.transactions.xa.internal.journal.TransientJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJournalProvider
implements JournalProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJournalProvider.class);
    private volatile LocalPersistenceService persistenceService;

    public void start(ServiceProvider<Service> serviceProvider) {
        this.persistenceService = (LocalPersistenceService)serviceProvider.getService(LocalPersistenceService.class);
    }

    public void stop() {
        this.persistenceService = null;
    }

    @Override
    public <K> Journal<K> getJournal(PersistableResourceService.PersistenceSpaceIdentifier<?> persistentSpaceId, Serializer<K> keySerializer) {
        if (persistentSpaceId == null) {
            LOGGER.info("Using transient XAStore journal");
            return new TransientJournal();
        }
        try {
            LOGGER.info("Using persistent XAStore journal");
            FileBasedPersistenceContext persistenceContext = this.persistenceService.createPersistenceContextWithin(persistentSpaceId, "XAJournal");
            return new PersistentJournal<K>(persistenceContext.getDirectory(), keySerializer);
        }
        catch (CachePersistenceException cpe) {
            throw new RuntimeException(cpe);
        }
    }
}

