/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.UUID;

public class JvmIDUtil {
    private static final String SYS_PROP_KEY_FOR_JVM_ID_BASE_SHARE = "___terracotta_jvm_uuid";
    private static String jvmId;

    private static String generateJVMIdBaseShare() {
        return UUID.randomUUID().toString();
    }

    private static String generateJVMIdExtensionShare() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        return Long.toHexString(bean.getStartTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJvmID() {
        String string = SYS_PROP_KEY_FOR_JVM_ID_BASE_SHARE.intern();
        synchronized (string) {
            if (jvmId != null) {
                return jvmId;
            }
            String base = System.getProperty(SYS_PROP_KEY_FOR_JVM_ID_BASE_SHARE);
            if (base == null) {
                base = JvmIDUtil.generateJVMIdBaseShare();
                System.setProperty(SYS_PROP_KEY_FOR_JVM_ID_BASE_SHARE, base);
            }
            jvmId = base + "-" + JvmIDUtil.generateJVMIdExtensionShare();
            return jvmId;
        }
    }
}

