/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.bytes.TCByteBuffer;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.AbstractTCNetworkMessage;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.transport.WireProtocolHeader;
import com.tc.net.protocol.transport.WireProtocolMessage;

public class WireProtocolMessageImpl
extends AbstractTCNetworkMessage
implements WireProtocolMessage {
    private final TCConnection sourceConnection;

    public static WireProtocolMessage wrapMessage(TCNetworkMessage msgPayload, TCConnection source) {
        WireProtocolHeader header = new WireProtocolHeader();
        header.setProtocol(WireProtocolHeader.getProtocolForMessageClass(msgPayload));
        if (!msgPayload.isSealed()) {
            msgPayload.seal();
        }
        WireProtocolMessageImpl rv = new WireProtocolMessageImpl(source, (TCNetworkHeader)header, msgPayload);
        return rv;
    }

    protected WireProtocolMessageImpl(TCConnection source, TCNetworkHeader header, TCByteBuffer[] data) {
        super(header, data);
        this.recordLength();
        this.sourceConnection = source;
    }

    private WireProtocolMessageImpl(TCConnection source, TCNetworkHeader header, TCNetworkMessage subMessage) {
        super(header, subMessage);
        this.recordLength();
        this.sourceConnection = source;
    }

    @Override
    public short getMessageProtocol() {
        return ((WireProtocolHeader)this.getHeader()).getProtocol();
    }

    @Override
    public WireProtocolHeader getWireProtocolHeader() {
        return (WireProtocolHeader)this.getHeader();
    }

    @Override
    public TCConnection getSource() {
        return this.sourceConnection;
    }

    protected void recordLength() {
        TCNetworkMessage msgPayload = this.getMessagePayload();
        int packetLength = msgPayload == null ? this.getTotalLength() : this.getHeader().getHeaderByteLength() + msgPayload.getTotalLength();
        ((WireProtocolHeader)this.getHeader()).setTotalPacketLength(packetLength);
    }
}

