/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.protocol.transport.ClientConnectionErrorListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ClientConnectionErrorDetails
implements ClientConnectionErrorListener {
    private volatile ConcurrentHashMap<InetSocketAddress, ConcurrentLinkedQueue<Exception>> exceptionMap;

    @Override
    public void onError(InetSocketAddress serverAddress, Exception e) {
        ConcurrentHashMap<InetSocketAddress, ConcurrentLinkedQueue<Exception>> internalExceptionCollector = this.exceptionMap;
        if (internalExceptionCollector != null) {
            ConcurrentLinkedQueue<Exception> exceptionList = new ConcurrentLinkedQueue<Exception>();
            exceptionList.add(e);
            internalExceptionCollector.put(serverAddress, exceptionList);
        }
    }

    public Map<String, List<Exception>> getErrors() {
        HashMap<String, List<Exception>> errorMessagesMap = new HashMap<String, List<Exception>>();
        ConcurrentHashMap<InetSocketAddress, ConcurrentLinkedQueue<Exception>> internalExceptionCollector = this.exceptionMap;
        if (internalExceptionCollector != null) {
            for (Map.Entry<InetSocketAddress, ConcurrentLinkedQueue<Exception>> entry : internalExceptionCollector.entrySet()) {
                InetSocketAddress serverAddress = entry.getKey();
                ConcurrentLinkedQueue<Exception> exceptionList = entry.getValue();
                Object[] errorObjects = exceptionList.toArray();
                ArrayList<Exception> errorMessages = new ArrayList<Exception>();
                for (Object errorObj : errorObjects) {
                    Exception e = (Exception)errorObj;
                    errorMessages.add(e);
                }
                errorMessagesMap.put(serverAddress.toString(), errorMessages);
            }
        }
        return errorMessagesMap;
    }

    public void attachCollector() {
        this.exceptionMap = new ConcurrentHashMap();
    }

    public void removeCollector() {
        this.exceptionMap = null;
    }
}

