/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.net.core.TCListener;
import com.tc.net.protocol.tcm.ChannelManager;
import com.tc.net.protocol.tcm.ChannelManagerImpl;
import com.tc.net.protocol.tcm.CommunicationsManagerImpl;
import com.tc.net.protocol.tcm.NetworkListener;
import com.tc.net.protocol.tcm.RedirectAddressProvider;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import com.tc.util.TCTimeoutException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NetworkListenerImpl
implements NetworkListener {
    private static Logger LOGGER = LoggerFactory.getLogger(NetworkListenerImpl.class);
    private final ChannelManagerImpl channelManager;
    private final CommunicationsManagerImpl commsMgr;
    private final InetSocketAddress addr;
    private TCListener lsnr;
    private CompletableFuture<Boolean> started = null;
    private final boolean reuseAddr;
    private final ConnectionIDFactory connectionIdFactory;
    private final WireProtocolMessageSink wireProtoMsgSnk;
    private final RedirectAddressProvider activeProvider;
    private final Predicate<MessageTransport> validation;

    NetworkListenerImpl(InetSocketAddress addr, CommunicationsManagerImpl commsMgr, ChannelManagerImpl channelManager, TCMessageFactory msgFactory, boolean reuseAddr, ConnectionIDFactory connectionIdFactory, WireProtocolMessageSink wireProtoMsgSnk, RedirectAddressProvider activeProvider, Predicate<MessageTransport> validation) {
        this.commsMgr = commsMgr;
        this.channelManager = channelManager;
        this.addr = addr;
        this.connectionIdFactory = connectionIdFactory;
        this.wireProtoMsgSnk = wireProtoMsgSnk;
        this.reuseAddr = reuseAddr;
        this.activeProvider = activeProvider;
        this.validation = validation;
    }

    @Override
    public void start(Set<ConnectionID> initialConnectionIDs) throws IOException {
        CompletableFuture<Boolean> startDone = this.start();
        if (startDone == null) {
            LOGGER.info("network listener already started");
        } else {
            try {
                this.lsnr = this.commsMgr.createCommsListener(this.addr, this.channelManager, this.reuseAddr, initialConnectionIDs, this.activeProvider, this.validation, this.connectionIdFactory, this.wireProtoMsgSnk);
                this.commsMgr.registerListener(this);
                startDone.complete(true);
            }
            catch (IOException ioe) {
                startDone.completeExceptionally(ioe);
                throw ioe;
            }
            finally {
                if (!startDone.isDone()) {
                    startDone.complete(false);
                }
            }
        }
    }

    @Override
    public void stop(long timeout) throws TCTimeoutException {
        CompletableFuture<Boolean> startDone = this.stop();
        try {
            boolean stop;
            if (timeout == 0L) {
                stop = (Boolean)startDone.get();
            } else {
                long time = System.currentTimeMillis();
                stop = (Boolean)startDone.get(timeout, TimeUnit.MILLISECONDS);
                if ((timeout -= System.currentTimeMillis() - time) <= 0L) {
                    throw new TCTimeoutException("unable to stop network listener in time alloted");
                }
            }
            if (stop) {
                this.lsnr.stop(timeout);
                this.commsMgr.unregisterListener(this);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.warn("listener not stopped", (Throwable)e);
        }
        catch (TimeoutException to) {
            throw new TCTimeoutException(to);
        }
    }

    private synchronized CompletableFuture<Boolean> start() {
        if (this.started == null) {
            this.started = new CompletableFuture();
            return this.started;
        }
        return null;
    }

    private synchronized CompletableFuture<Boolean> stop() {
        if (this.started == null) {
            this.started = CompletableFuture.completedFuture(false);
        }
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStarted() {
        CompletableFuture<Boolean> startDone = null;
        NetworkListenerImpl networkListenerImpl = this;
        synchronized (networkListenerImpl) {
            if (this.started == null) {
                return false;
            }
            startDone = this.started;
        }
        try {
            return (Boolean)startDone.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
    }

    @Override
    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    @Override
    public synchronized InetAddress getBindAddress() {
        if (!this.isStarted()) {
            return this.addr.getAddress();
        }
        return this.lsnr.getBindSocketAddress().getAddress();
    }

    @Override
    public synchronized int getBindPort() {
        if (!this.isStarted()) {
            return this.addr.getPort();
        }
        return this.lsnr.getBindSocketAddress().getPort();
    }

    public String toString() {
        try {
            NetworkInterface eth = NetworkInterface.getByInetAddress(this.addr.getAddress());
            if (eth != null) {
                return "interface:" + eth.getDisplayName() + " (address:" + this.addr.getAddress() + " port:" + this.addr.getPort() + ')';
            }
            return "all interfaces (address:" + this.addr.getAddress() + " port:" + this.addr.getPort() + ')';
        }
        catch (Exception e) {
            return "Exception in toString(): " + e.getMessage();
        }
    }
}

