/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)?)?(?:\\.(\\d+)?)?(?:\\.(\\d+)?)?)?(?:_(\\w+))?(?:-(\\w+))?$");
    private final int major;
    private final int minor;
    private final int micro;
    private final int patch;
    private final int build;
    private final String specifier;
    private final String qualifier;

    public Version(String version) {
        Matcher m = VERSION_PATTERN.matcher(version);
        if (!m.matches()) {
            throw this.invalidVersion(version);
        }
        this.major = Integer.parseInt(m.group(1));
        String minorStr = m.group(2);
        if (minorStr != null) {
            this.minor = Integer.parseInt(minorStr);
            String microStr = m.group(3);
            if (microStr != null) {
                this.micro = Integer.parseInt(microStr);
                String patchStr = m.group(4);
                if (patchStr != null) {
                    this.patch = Integer.parseInt(patchStr);
                    String buildStr = m.group(5);
                    this.build = buildStr != null ? Integer.parseInt(buildStr) : 0;
                } else {
                    this.patch = 0;
                    this.build = 0;
                }
            } else {
                this.micro = 0;
                this.patch = 0;
                this.build = 0;
            }
        } else {
            this.minor = 0;
            this.micro = 0;
            this.patch = 0;
            this.build = 0;
        }
        this.specifier = m.group(6);
        this.qualifier = m.group(7);
    }

    public static boolean isValidVersionString(String version) {
        Matcher m = VERSION_PATTERN.matcher(version);
        return m.matches();
    }

    private IllegalArgumentException invalidVersion(String input) {
        return new IllegalArgumentException("Invalid version, unable to parse: " + input);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int micro() {
        return this.micro;
    }

    private int patch() {
        return this.patch;
    }

    private int build() {
        return this.build;
    }

    public boolean isNewer(Version v, int depth) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (depth < 1 || depth > 5) {
            throw new IndexOutOfBoundsException();
        }
        int[] v1 = new int[]{this.major, this.minor, this.micro, this.patch, this.build};
        int[] v2 = new int[]{v.major, v.minor, v.micro, v.patch, v.build};
        for (int i = 0; i < depth; ++i) {
            if (v1[i] > v2[i]) {
                return true;
            }
            if (v1[i] == v2[i]) continue;
            return false;
        }
        return false;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public String specifier() {
        return this.specifier;
    }

    @Override
    public int compareTo(Version otherVersion) {
        int majorDiff = this.major - otherVersion.major();
        if (majorDiff != 0) {
            return majorDiff;
        }
        int minorDiff = this.minor - otherVersion.minor();
        if (minorDiff != 0) {
            return minorDiff;
        }
        int microDiff = this.micro - otherVersion.micro();
        if (microDiff != 0) {
            return microDiff;
        }
        int patchDiff = this.patch - otherVersion.patch();
        if (patchDiff != 0) {
            return patchDiff;
        }
        int buildDiff = this.build - otherVersion.build();
        if (buildDiff != 0) {
            return buildDiff;
        }
        if (this.specifier == null) {
            if (otherVersion.specifier != null) {
                return 1;
            }
        } else {
            if (otherVersion.specifier == null) {
                return -1;
            }
            if (this.specifier.compareTo(otherVersion.specifier) != 0) {
                return this.specifier.compareTo(otherVersion.specifier);
            }
        }
        if (this.qualifier == null) {
            if (otherVersion.qualifier != null) {
                return 1;
            }
        } else {
            if (otherVersion.qualifier == null) {
                return -1;
            }
            return this.qualifier.compareTo(otherVersion.qualifier);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return this.compareTo((Version)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder versionString = new StringBuilder().append(this.major);
        versionString.append(".").append(this.minor).append(".").append(this.micro).append(".").append(this.patch).append(".").append(this.build);
        if (this.specifier != null) {
            versionString.append("_" + this.specifier);
        }
        if (this.qualifier != null) {
            versionString.append("-" + this.qualifier);
        }
        return versionString.toString();
    }
}

