/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.util.ArchiveBuilder;
import com.tc.util.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipBuilder
implements ArchiveBuilder {
    private final CRC32 crc32 = new CRC32();
    private final ZipOutputStream zout;
    private final Set<String> dirSet = new HashSet<String>();
    private final Set<String> entrySet = new HashSet<String>();
    private final boolean verbose;

    public ZipBuilder(File archiveFile, boolean useCompression) throws IOException {
        this(archiveFile, useCompression, false);
    }

    public ZipBuilder(File archiveFile, boolean useCompression, boolean verbose) throws IOException {
        this.zout = this.getArchiveOutputStream(archiveFile);
        if (useCompression) {
            this.zout.setMethod(8);
            this.zout.setLevel(9);
        } else {
            this.zout.setMethod(0);
            this.zout.setLevel(0);
        }
        this.verbose = verbose;
    }

    @Override
    public final void putTraverseDirectory(File dir, String dirName) throws IOException {
        String[] files;
        if (!dir.isDirectory()) {
            throw new IOException("Unexpected Exception: " + dir + "\nis not a directory");
        }
        if (dirName != null && !dirName.isEmpty()) {
            this.putDirEntry(dirName);
            dirName = dirName + File.separator;
        } else {
            dirName = "";
        }
        for (String file2 : files = dir.list()) {
            File file = new File(dir.getAbsolutePath() + File.separator + file2);
            if (file.isDirectory()) {
                this.putTraverseDirectory(file, dirName + file.getName());
                continue;
            }
            this.putEntry(dirName + file2, this.readFile(file));
        }
    }

    @Override
    public final void putDirEntry(String file) throws IOException {
        if (file == null) {
            return;
        }
        if (this.dirSet.contains(file)) {
            return;
        }
        this.dirSet.add(file);
        String dirEntry = this.archivePath(file) + "/";
        ZipEntry entry = this.createEntry(dirEntry);
        entry.setSize(0L);
        entry.setCrc(0L);
        this.zout.putNextEntry(entry);
        if (this.verbose) {
            System.out.println(dirEntry);
        }
    }

    @Override
    public final void putEntry(String file, byte[] bytes) throws IOException {
        if (this.entrySet.contains(file.toString())) {
            return;
        }
        this.entrySet.add(file.toString());
        String fileEntry = this.archivePath(file);
        ZipEntry entry = this.createEntry(fileEntry);
        entry.setSize(bytes.length);
        entry.setCrc(this.getCrc32(bytes));
        this.zout.putNextEntry(entry);
        this.zout.write(bytes, 0, bytes.length);
        if (this.verbose) {
            System.out.println(fileEntry);
        }
    }

    @Override
    public final void finish() throws IOException {
        this.zout.close();
    }

    @Override
    public final byte[] readFile(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        byte[] bytes = new byte[in.available()];
        in.read(bytes);
        in.close();
        return bytes;
    }

    protected ZipEntry createEntry(String name) {
        return new ZipEntry(name);
    }

    protected ZipOutputStream getArchiveOutputStream(File archiveFile) throws IOException {
        if (this.zout != null) {
            throw new IllegalStateException("ArchiveOutputStream has already been instantiated.");
        }
        return new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(archiveFile)));
    }

    private long getCrc32(byte[] bytes) {
        this.crc32.update(bytes);
        long checksum = this.crc32.getValue();
        this.crc32.reset();
        return checksum;
    }

    private String archivePath(String file) {
        if (File.separator.equals("/")) {
            return file;
        }
        return file.replaceAll("\\\\", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(InputStream archive, File destDir) throws IOException {
        try (ZipInputStream zis = null;){
            ZipEntry entry;
            zis = new ZipInputStream(archive);
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    if (!file.mkdirs()) {
                        throw new IOException("failed to create directory " + file.getAbsolutePath());
                    }
                } else {
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(file);
                        IOUtils.copy(zis, out);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(out);
                }
                zis.closeEntry();
            }
            return;
        }
    }
}

