/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class CompositeIterator<E>
implements Iterator<E> {
    private final List<Iterator<E>> iterators = new ArrayList<Iterator<E>>();
    private int nextIteratorIdx = 0;

    public CompositeIterator(List<Iterator<E>> iterators) {
        Objects.requireNonNull(iterators);
        this.iterators.addAll(iterators);
    }

    @Override
    public boolean hasNext() {
        while (this.nextIteratorIdx < this.iterators.size() && !this.iterators.get(this.nextIteratorIdx).hasNext()) {
            ++this.nextIteratorIdx;
        }
        return this.nextIteratorIdx < this.iterators.size() && this.iterators.get(this.nextIteratorIdx).hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iterators.get(this.nextIteratorIdx).next();
    }
}

