/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.lock;

import java.util.concurrent.Semaphore;
import org.ehcache.clustered.common.internal.lock.LockMessaging;
import org.terracotta.connection.entity.Entity;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;

public class VoltronReadWriteLockClient
implements Entity {
    private final EntityClientEndpoint<LockMessaging.LockOperation, LockMessaging.LockTransition> endpoint;
    private final Semaphore wakeup = new Semaphore(0);
    private volatile LockMessaging.LockOperation currentState = null;

    public VoltronReadWriteLockClient(EntityClientEndpoint<LockMessaging.LockOperation, LockMessaging.LockTransition> endpoint) {
        this.endpoint = endpoint;
        this.endpoint.setDelegate(new EndpointDelegate<LockMessaging.LockTransition>(){

            @Override
            public void handleMessage(LockMessaging.LockTransition response) {
                if (response.isReleased()) {
                    VoltronReadWriteLockClient.this.wakeup.release();
                }
            }

            @Override
            public byte[] createExtendedReconnectData() {
                try {
                    LockMessaging.LockOperation state = VoltronReadWriteLockClient.this.getCurrentState();
                    if (state == null) {
                        return new byte[0];
                    }
                    return LockMessaging.codec().encodeMessage(state);
                }
                catch (MessageCodecException e) {
                    throw new AssertionError((Object)e);
                }
            }

            @Override
            public void didDisconnectUnexpectedly() {
            }
        });
    }

    @Override
    public void close() {
        this.endpoint.close();
    }

    public boolean tryLock(LockMessaging.HoldType type) {
        LockMessaging.LockTransition transition = this.invoke(LockMessaging.tryLock(type));
        if (transition.isAcquired()) {
            this.currentState = LockMessaging.lock(type);
            return true;
        }
        return false;
    }

    public void lock(LockMessaging.HoldType type) {
        while (true) {
            LockMessaging.LockTransition transition;
            if ((transition = this.invoke(LockMessaging.lock(type))).isAcquired()) {
                this.currentState = LockMessaging.lock(type);
                return;
            }
            this.wakeup.acquireUninterruptibly();
        }
    }

    public void unlock(LockMessaging.HoldType type) {
        LockMessaging.LockTransition transition = this.invoke(LockMessaging.unlock(type));
        if (!transition.isReleased()) {
            throw new IllegalMonitorStateException();
        }
        this.currentState = null;
    }

    private LockMessaging.LockOperation getCurrentState() {
        return this.currentState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LockMessaging.LockTransition invoke(LockMessaging.LockOperation operation) {
        try {
            InvokeFuture<LockMessaging.LockTransition> result = this.endpoint.beginInvoke().message(operation).replicate(false).invoke();
            boolean interrupted = false;
            while (true) {
                try {
                    LockMessaging.LockTransition lockTransition = result.get();
                    return lockTransition;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                catch (EntityException ex) {
                    throw new IllegalStateException(ex);
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (MessageCodecException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

