/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bytes;

import com.tc.bytes.BufferPool;
import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferImpl;
import java.nio.ReadOnlyBufferException;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCByteBufferFactory {
    private static boolean POOLING = false;
    private static int THREAD_MAX = 1024;
    public static final int FIXED_BUFFER_SIZE = 4096;
    private static final int WARN_THRESHOLD = 0xA00000;
    private static final TCByteBuffer[] EMPTY_BB_ARRAY = new TCByteBuffer[0];
    private static final TCByteBuffer ZERO_BYTE_BUFFER = TCByteBufferImpl.wrap(new byte[0]);
    private static final Logger logger = LoggerFactory.getLogger(TCByteBufferFactory.class);
    private static final ThreadLocal<Queue<TCByteBuffer>> DIRECT_POOL = ThreadLocal.withInitial(() -> new PoolQueue());
    private static final ThreadLocal<Queue<TCByteBuffer>> HEAP_POOL = ThreadLocal.withInitial(() -> new PoolQueue());

    public static void setPoolingEnabled(boolean val) {
        POOLING = val;
    }

    public static void setPoolingThreadMax(int size) {
        THREAD_MAX = size;
    }

    private static TCByteBuffer createNewInstance(boolean direct, int capacity, int index, int totalCount, boolean usePool) {
        try {
            TCByteBufferImpl rv = new TCByteBufferImpl(capacity, direct, usePool ? (direct ? DIRECT_POOL.get() : HEAP_POOL.get()) : null);
            return rv;
        }
        catch (OutOfMemoryError oome) {
            logger.error("OOME trying to allocate " + (direct ? "direct" : "non-direct") + " buffer of size " + capacity + " (index " + index + " of count " + totalCount + ")");
            throw oome;
        }
    }

    public static TCByteBuffer getInstance(boolean direct, int size) {
        if (size > 0xA00000) {
            logger.warn("Asking for a large amount of memory: " + size + " bytes");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Requested length cannot be less than zero");
        }
        if (size == 0) {
            return ZERO_BYTE_BUFFER;
        }
        return TCByteBufferFactory.createNewInstance(direct, size);
    }

    private static TCByteBuffer createNewInstance(boolean direct, int bufferSize) {
        return TCByteBufferFactory.createNewInstance(direct, bufferSize, 0, 1, false);
    }

    public static TCByteBuffer[] getFixedSizedInstancesForLength(boolean direct, int length) {
        if (length > 0xA00000) {
            logger.warn("Asking for a large amount of memory: " + length + " bytes");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Requested length cannot be less than zero");
        }
        if (length == 0) {
            return EMPTY_BB_ARRAY;
        }
        int numBuffers = TCByteBufferFactory.getBufferCountNeededForMessageSize(length);
        TCByteBuffer[] rv = new TCByteBuffer[numBuffers];
        Queue<TCByteBuffer> pool = !POOLING ? null : (direct ? DIRECT_POOL.get() : HEAP_POOL.get());
        for (int i = 0; i < numBuffers; ++i) {
            if (pool != null) {
                rv[i] = pool.poll();
            }
            if (rv[i] == null) {
                rv[i] = TCByteBufferFactory.createNewInstance(direct, 4096, i, numBuffers, POOLING);
                continue;
            }
            rv[i].checkedOut();
        }
        TCByteBuffer lastBuffer = rv[rv.length - 1];
        lastBuffer.limit(lastBuffer.capacity() - (numBuffers * 4096 - length));
        return rv;
    }

    private static int getBufferCountNeededForMessageSize(int length) {
        int numBuffers = length / 4096;
        if (length % 4096 != 0) {
            ++numBuffers;
        }
        return numBuffers;
    }

    public static int getTotalBufferSizeNeededForMessageSize(int length) {
        return TCByteBufferFactory.getBufferCountNeededForMessageSize(length) * 4096;
    }

    public static void returnBuffers(TCByteBuffer[] buffers) {
        for (TCByteBuffer buf : buffers) {
            TCByteBufferFactory.returnBuffer(buf);
        }
    }

    public static void returnBuffer(TCByteBuffer buf) {
        if (buf.capacity() == 4096) {
            BufferPool bufferPool = buf.getBufferPool();
            buf.commit();
            if (bufferPool != null) {
                try {
                    bufferPool.offer(buf);
                }
                catch (InterruptedException e) {
                    logger.warn("interrupted while trying to return buffer", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static TCByteBuffer wrap(byte[] buf) {
        if (buf == null) {
            return null;
        }
        return TCByteBufferImpl.wrap(buf);
    }

    public static byte[] unwrap(TCByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        byte[] array = null;
        try {
            array = buffer.array();
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            // empty catch block
        }
        if (array == null || buffer.position() != 0 || buffer.remaining() != array.length || buffer.arrayOffset() != 0) {
            array = new byte[buffer.remaining()];
            buffer.duplicate().get(array);
        }
        return array;
    }

    public static TCByteBuffer copyAndWrap(byte[] buf) {
        TCByteBuffer rv = null;
        if (buf != null) {
            rv = TCByteBufferFactory.getInstance(false, buf.length);
            rv.put(buf).rewind();
        } else {
            rv = TCByteBufferFactory.getInstance(false, 0);
        }
        return rv;
    }

    public static boolean isPoolingEnabled() {
        return POOLING;
    }

    private static class PoolQueue
    extends AbstractQueue<TCByteBuffer> {
        private TCByteBuffer[] store = new TCByteBuffer[TCByteBufferFactory.access$000()];
        private int pointer = 0;

        private PoolQueue() {
        }

        @Override
        public Iterator<TCByteBuffer> iterator() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int size() {
            return this.pointer;
        }

        @Override
        public synchronized boolean offer(TCByteBuffer e) {
            if (this.store.length != THREAD_MAX) {
                this.store = Arrays.copyOf(this.store, THREAD_MAX);
            }
            if (this.pointer < this.store.length) {
                this.store[this.pointer++] = e;
                return true;
            }
            return false;
        }

        @Override
        public synchronized TCByteBuffer poll() {
            return this.pointer > 0 ? this.store[--this.pointer] : null;
        }

        @Override
        public TCByteBuffer peek() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

