/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.net.core.BufferManagerFactory;
import com.tc.net.core.BufferManagerFactorySupplier;
import com.tc.net.core.ClearTextBufferManagerFactory;
import com.tc.net.core.ProductID;
import com.tc.object.ClientBuilder;
import com.tc.object.ClientBuilderFactory;
import com.tc.object.StandardClientBuilder;
import com.terracotta.diagnostic.DiagnosticClientBuilder;
import java.util.Properties;

public class StandardClientBuilderFactory
implements ClientBuilderFactory {
    private final String scheme;
    private final BufferManagerFactorySupplier supplier;

    public StandardClientBuilderFactory(String scheme) {
        BufferManagerFactorySupplier base = ClientBuilderFactory.get(BufferManagerFactorySupplier.class);
        this.scheme = scheme;
        this.supplier = base == null ? p -> new ClearTextBufferManagerFactory() : p -> {
            BufferManagerFactory factory = base.createBufferManagerFactory(p);
            if (factory == null) {
                return new ClearTextBufferManagerFactory();
            }
            return factory;
        };
    }

    @Override
    public ClientBuilder create(Properties connectionProperties) {
        String type = connectionProperties.getProperty("connection.type", this.scheme);
        if (type.equalsIgnoreCase("diagnostic")) {
            return new DiagnosticClientBuilder(connectionProperties, this.supplier.createBufferManagerFactory(connectionProperties));
        }
        if (type.equalsIgnoreCase("terracotta")) {
            return new StandardClientBuilder(connectionProperties, this.supplier.createBufferManagerFactory(connectionProperties));
        }
        for (ProductID pid : ProductID.values()) {
            if (!pid.name().equalsIgnoreCase(type)) continue;
            return new StandardClientBuilder(connectionProperties, this.supplier.createBufferManagerFactory(connectionProperties));
        }
        throw new IllegalArgumentException(type + " is not a valid connection type");
    }
}

