/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.Collection;
import java.util.Objects;

public class TerracottaKit {
    private final String version;
    private final String buildID;
    private final Collection<Component> installedComponents;

    public TerracottaKit(String version, String buildID, Collection<Component> installedComponents) {
        this.version = version;
        this.buildID = buildID;
        this.installedComponents = installedComponents;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildID() {
        return this.buildID;
    }

    public Collection<Component> getInstalledComponents() {
        return this.installedComponents;
    }

    public String toString() {
        return this.getVersion() + ", as of " + this.getBuildID();
    }

    public static class Component {
        private final Type type;
        private final String name;
        private final String description;
        private final String version;
        private final String buildTimestamp;
        private final String buildJDK;

        public Component(Type type, String name, String description, String version, String buildTimestamp, String buildJDK) {
            this.type = Objects.requireNonNull(type);
            this.name = Objects.requireNonNull(name);
            this.description = description;
            this.version = version;
            this.buildTimestamp = buildTimestamp;
            this.buildJDK = buildJDK;
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVersion() {
            return this.version;
        }

        public String getBuildTimestamp() {
            return this.buildTimestamp;
        }

        public String getBuildJDK() {
            return this.buildJDK;
        }

        public String toString() {
            return String.format("%-35s %-15s (built on %s with JDK %s)", this.getName(), this.getVersion(), this.getBuildTimestamp(), this.getBuildJDK());
        }

        public static enum Type {
            CONFIG,
            PLUGIN,
            SERVICE,
            ENTITY,
            UNKNOWN;


            public static Type from(String type) {
                for (Type t : Type.values()) {
                    if (!t.name().equalsIgnoreCase(type)) continue;
                    return t;
                }
                return UNKNOWN;
            }
        }
    }
}

