/*
 * Decompiled with CFR 0.152.
 */
package com.tc.lang;

import com.tc.lang.ThrowableHandler;
import com.tc.logging.CallbackOnExitHandler;
import com.tc.util.runtime.ThreadDumpUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCThreadGroup
extends ThreadGroup {
    private final ThrowableHandler throwableHandler;
    private final boolean stoppable;
    private static final Logger LOGGER = LoggerFactory.getLogger(TCThreadGroup.class);

    public TCThreadGroup(ThrowableHandler throwableHandler) {
        this(throwableHandler, "TC Thread Group");
    }

    public TCThreadGroup(ThrowableHandler throwableHandler, String name) {
        this(throwableHandler, name, true);
    }

    public TCThreadGroup(ThrowableHandler throwableHandler, String name, boolean stoppable) {
        super(name);
        this.throwableHandler = throwableHandler;
        this.stoppable = stoppable;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.throwableHandler.handleThrowable(thread, throwable);
    }

    public void addCallbackOnExitDefaultHandler(CallbackOnExitHandler callbackOnExitHandler) {
        this.throwableHandler.addCallbackOnExitDefaultHandler(callbackOnExitHandler);
    }

    public void addCallbackOnExitExceptionHandler(Class<?> c, CallbackOnExitHandler callbackOnExitHandler) {
        this.throwableHandler.addCallbackOnExitExceptionHandler(c, callbackOnExitHandler);
    }

    public boolean isStoppable() {
        return this.stoppable;
    }

    public void printLiveThreads(Consumer<String> reporter) {
        for (Thread t : this.threads()) {
            if (t == null || t == Thread.currentThread()) continue;
            reporter.accept(ThreadDumpUtil.getThreadDump(t));
        }
    }

    public void interruptThreads() {
        this.threads().stream().filter(t -> t != Thread.currentThread() && t.isAlive()).forEach(Thread::interrupt);
    }

    public boolean retire(long timeout, Consumer<InterruptedException> interruptHandler) {
        boolean complete = false;
        long killStart = System.currentTimeMillis();
        if (this.stoppable) {
            while (!complete && System.currentTimeMillis() < killStart + timeout) {
                complete = true;
                for (Thread t : this.threads()) {
                    if (t == Thread.currentThread()) continue;
                    try {
                        t.join(500L);
                    }
                    catch (InterruptedException i) {
                        interruptHandler.accept(i);
                    }
                    complete = complete && !t.isAlive();
                }
            }
            if (this.activeCount() == 0) {
                this.destroy();
            }
        }
        if (complete) {
            LOGGER.info("finished thread exiting in {} seconds", (Object)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - killStart));
        }
        return complete;
    }

    private synchronized List<Thread> threads() {
        int ac = this.activeCount();
        Thread[] list = new Thread[ac];
        this.enumerate(list, true);
        return Arrays.stream(list).filter(t -> t != null && t.isAlive()).collect(Collectors.toList());
    }
}

