/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.lease.Lease;
import org.terracotta.lease.LeaseMaintainer;

class CleaningLeaseMaintainer
implements LeaseMaintainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleaningLeaseMaintainer.class);
    private final LeaseMaintainer delegate;
    private final Connection connection;
    private final List<Closeable> resources;

    CleaningLeaseMaintainer(LeaseMaintainer delegate, Connection connection, Closeable ... resources) {
        this(delegate, connection, Arrays.asList(resources));
    }

    private CleaningLeaseMaintainer(LeaseMaintainer delegate, Connection connection, List<Closeable> resources) {
        this.delegate = delegate;
        this.connection = connection;
        this.resources = resources;
    }

    @Override
    public Lease getCurrentLease() {
        return this.delegate.getCurrentLease();
    }

    @Override
    public void waitForLease() throws InterruptedException {
        this.delegate.waitForLease();
    }

    @Override
    public boolean waitForLease(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.waitForLease(timeout, timeUnit);
    }

    @Override
    public void close() throws IOException {
        this.closeResources();
        this.delegate.close();
    }

    @Override
    public void destroy() throws IOException {
        this.closeResources();
        this.connection.close();
    }

    private void closeResources() {
        for (Closeable resource : this.resources) {
            try {
                resource.close();
            }
            catch (Throwable t) {
                LOGGER.info("Exception closing resource: " + resource, t);
            }
        }
    }
}

