/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import java.util.Collection;
import java.util.NoSuchElementException;

public class MergableLinkedList<T> {
    private int size = 0;
    private Node<T> head;
    private Node<T> tail;

    public void addAll(Collection<T> c) {
        for (T element : c) {
            this.add(element);
        }
    }

    public void mergeToFront(MergableLinkedList<T> m) {
        if (m.isEmpty()) {
            return;
        }
        ((Node)m.tail).next = (Node)this.head;
        this.head = m.head;
        if (this.tail == null) {
            this.tail = m.tail;
        }
        this.size += m.size();
        m.clear();
    }

    public void clear() {
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public T removeFirst() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        Object toReturn = ((Node)this.head).data;
        if (this.head == this.tail) {
            this.tail = null;
            this.head = null;
        } else {
            this.head = ((Node)this.head).next;
        }
        --this.size;
        return (T)toReturn;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(T t) {
        Node<T> n = new Node<T>(t);
        if (this.head == null) {
            this.head = n;
        } else {
            ((Node)this.tail).next = (Node)n;
        }
        this.tail = n;
        ++this.size;
    }

    private static final class Node<T> {
        private Node<T> next;
        private final T data;

        public Node(T data) {
            this.data = data;
        }
    }
}

