/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.bytes.TCReference;
import com.tc.bytes.TCReferenceSupport;
import com.tc.io.TCByteBufferInputStream;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCNetworkMessageImpl;
import com.tc.net.protocol.TCProtocolException;
import com.tc.net.protocol.tcm.TCActionNetworkMessage;
import com.tc.net.protocol.transport.WireProtocolGroupMessage;
import com.tc.net.protocol.transport.WireProtocolHeader;
import com.tc.net.protocol.transport.WireProtocolMessageImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WireProtocolGroupMessageImpl
extends TCNetworkMessageImpl
implements WireProtocolGroupMessage {
    private final TCConnection sourceConnection;
    private final List<TCActionNetworkMessage> messagePayloads;

    public static WireProtocolGroupMessageImpl wrapMessages(List<TCActionNetworkMessage> msgPayloads, TCConnection source) {
        WireProtocolHeader header = new WireProtocolHeader();
        header.setProtocol((short)5);
        return new WireProtocolGroupMessageImpl(source, header, msgPayloads);
    }

    protected WireProtocolGroupMessageImpl(TCConnection source, WireProtocolHeader header, TCReference messagePayloadByteBuffers) {
        super(header);
        this.setPayload(messagePayloadByteBuffers);
        this.sourceConnection = source;
        this.messagePayloads = null;
    }

    protected WireProtocolGroupMessageImpl(TCConnection source, WireProtocolHeader header, List<TCActionNetworkMessage> messagePayloads) {
        super(header);
        this.sourceConnection = source;
        this.messagePayloads = messagePayloads;
    }

    @Override
    public boolean prepareToSend() {
        this.setPayload(this.generatePayload());
        this.getWireProtocolHeader().setMessageCount(this.messagePayloads.size());
        this.getWireProtocolHeader().finalizeHeader(this.getTotalLength());
        return this.getWireProtocolHeader().getMessageCount() > 0;
    }

    private TCReference generatePayload() {
        ArrayList<TCReference> msgs = new ArrayList<TCReference>(this.messagePayloads.size() * 2);
        Iterator<TCActionNetworkMessage> msgI = this.messagePayloads.iterator();
        while (msgI.hasNext()) {
            TCActionNetworkMessage msg = msgI.next();
            if (msg.commit()) {
                TCByteBuffer tcb = TCByteBufferFactory.getInstance(6);
                tcb.putInt(msg.getTotalLength());
                tcb.putShort(WireProtocolHeader.getProtocolForMessageClass(msg));
                tcb.flip();
                TCReference header = TCReferenceSupport.createGCReference(tcb);
                msgs.add(header);
                msg.addCompleteCallback(header::close);
                msgs.add(msg.getEntireMessageData());
                continue;
            }
            msg.complete();
            msgI.remove();
        }
        return TCReferenceSupport.createAggregateReference(msgs);
    }

    private List<TCNetworkMessage> getMessagesFromByteBuffers() throws IOException {
        ArrayList<TCNetworkMessage> messages = new ArrayList<TCNetworkMessage>();
        TCReference src = this.getPayload();
        try (TCByteBufferInputStream msgs = new TCByteBufferInputStream(src);){
            for (int i = 0; i < this.getWireProtocolHeader().getMessageCount(); ++i) {
                int msgLen = msgs.readInt();
                short msgProto = msgs.readShort();
                WireProtocolHeader hdr = (WireProtocolHeader)this.getWireProtocolHeader().clone();
                hdr.setTotalPacketLength(hdr.getHeaderByteLength() + msgLen);
                hdr.setProtocol(msgProto);
                hdr.setMessageCount(1);
                hdr.computeChecksum();
                WireProtocolMessageImpl msg = new WireProtocolMessageImpl(this.sourceConnection, (TCNetworkHeader)hdr, msgs.readReference(msgLen));
                messages.add(msg);
            }
        }
        return messages;
    }

    @Override
    public Iterator<TCNetworkMessage> getMessageIterator() throws TCProtocolException {
        try {
            return this.getMessagesFromByteBuffers().iterator();
        }
        catch (IOException ioe) {
            throw new TCProtocolException(ioe);
        }
    }

    @Override
    public int getTotalMessageCount() {
        return ((WireProtocolHeader)this.getHeader()).getMessageCount();
    }

    @Override
    public TCConnection getSource() {
        return this.sourceConnection;
    }

    @Override
    public WireProtocolHeader getWireProtocolHeader() {
        return (WireProtocolHeader)this.getHeader();
    }

    @Override
    public short getMessageProtocol() {
        return ((WireProtocolHeader)this.getHeader()).getProtocol();
    }

    @Override
    public void complete() {
        if (this.messagePayloads != null) {
            this.messagePayloads.iterator().forEachRemaining(TCNetworkMessage::complete);
        }
        super.complete();
    }

    @Override
    public boolean isValid() {
        return !this.messagePayloads.stream().allMatch(TCActionNetworkMessage::isCancelled);
    }
}

