/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCReference;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.AbstractTCNetworkHeader;
import com.tc.net.protocol.AbstractTCProtocolAdaptor;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCNetworkMessageImpl;
import com.tc.net.protocol.TCProtocolException;
import com.tc.net.protocol.transport.TransportMessageImpl;
import com.tc.net.protocol.transport.WireProtocolAdaptor;
import com.tc.net.protocol.transport.WireProtocolException;
import com.tc.net.protocol.transport.WireProtocolGroupMessage;
import com.tc.net.protocol.transport.WireProtocolGroupMessageImpl;
import com.tc.net.protocol.transport.WireProtocolHeader;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.net.protocol.transport.WireProtocolMessageImpl;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import java.util.Iterator;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireProtocolAdaptorImpl
extends AbstractTCProtocolAdaptor
implements WireProtocolAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(WireProtocolAdaptorImpl.class);
    private final WireProtocolMessageSink sink;

    protected WireProtocolAdaptorImpl(WireProtocolMessageSink sink) {
        super(logger);
        this.sink = sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReadData(TCConnection source, TCByteBuffer[] data, int length, Queue<TCByteBuffer> recycle) throws TCProtocolException {
        WireProtocolMessage msg;
        try {
            msg = (WireProtocolMessage)this.processIncomingData(source, data, length, recycle);
        }
        catch (TCProtocolException e) {
            this.init();
            throw e;
        }
        if (msg != null) {
            this.init();
            if (logger.isDebugEnabled()) {
                logger.debug("\nRECEIVE\n" + msg.toString());
            }
            if (msg.getWireProtocolHeader().isMessagesGrouped()) {
                WireProtocolGroupMessage wpmg = (WireProtocolGroupMessage)msg;
                try {
                    Iterator<TCNetworkMessage> i = wpmg.getMessageIterator();
                    while (i.hasNext()) {
                        WireProtocolMessage wpm = (WireProtocolMessage)i.next();
                        this.dispatch(wpm);
                    }
                }
                finally {
                    wpmg.complete();
                }
            } else {
                this.dispatch(msg);
            }
        }
    }

    private void dispatch(WireProtocolMessage msg) throws WireProtocolException {
        try {
            this.sink.putMessage(msg);
        }
        finally {
            msg.complete();
        }
    }

    @Override
    protected AbstractTCNetworkHeader getNewProtocolHeader() {
        return new WireProtocolHeader();
    }

    @Override
    protected int computeDataLength(TCNetworkHeader header) {
        WireProtocolHeader wph = (WireProtocolHeader)header;
        return wph.getTotalPacketLength() - wph.getHeaderByteLength();
    }

    @Override
    protected TCNetworkMessage createMessage(TCConnection source, TCNetworkHeader hdr, TCReference data) throws TCProtocolException {
        if (data == null) {
            throw new TCProtocolException("Wire protocol messages must have a payload");
        }
        WireProtocolHeader wph = (WireProtocolHeader)hdr;
        TCNetworkMessageImpl rv = wph.isHandshakeOrHealthCheckMessage() ? new TransportMessageImpl(source, (TCNetworkHeader)wph, data) : (wph.isMessagesGrouped() ? new WireProtocolGroupMessageImpl(source, wph, data) : new WireProtocolMessageImpl(source, (TCNetworkHeader)wph, data));
        return rv;
    }
}

