/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.MemoryUnit;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.LockContext;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.OptionalConfig;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.Version;
import org.terracotta.dynamic_config.api.service.Props;

public class Cluster
implements Cloneable,
PropertyHolder {
    private List<Stripe> stripes;
    private UID uid;
    private String name;
    private LockContext lockContext;
    private Measure<org.terracotta.common.struct.TimeUnit> clientReconnectWindow;
    private Measure<org.terracotta.common.struct.TimeUnit> clientLeaseDuration;
    private String securityAuthc;
    private Boolean securitySslTls;
    private Boolean securityWhitelist;
    private FailoverPriority failoverPriority;
    private Map<String, Measure<MemoryUnit>> offheapResources;

    public Cluster(List<Stripe> stripes) {
        this.stripes = new CopyOnWriteArrayList<Stripe>((Collection)Objects.requireNonNull(stripes));
    }

    public Cluster(Stripe ... stripes) {
        this(Arrays.asList(stripes));
    }

    @Override
    public Scope getScope() {
        return Scope.CLUSTER;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UID getUID() {
        return this.uid;
    }

    public Cluster setUID(UID uid) {
        this.uid = Objects.requireNonNull(uid);
        return this;
    }

    public OptionalConfig<String> getSecurityAuthc() {
        return OptionalConfig.of(Setting.SECURITY_AUTHC, this.securityAuthc);
    }

    public OptionalConfig<Boolean> getSecuritySslTls() {
        return OptionalConfig.of(Setting.SECURITY_SSL_TLS, this.securitySslTls);
    }

    public OptionalConfig<Boolean> getSecurityWhitelist() {
        return OptionalConfig.of(Setting.SECURITY_WHITELIST, this.securityWhitelist);
    }

    public FailoverPriority getFailoverPriority() {
        return this.failoverPriority;
    }

    public OptionalConfig<Measure<org.terracotta.common.struct.TimeUnit>> getClientReconnectWindow() {
        return OptionalConfig.of(Setting.CLIENT_RECONNECT_WINDOW, this.clientReconnectWindow);
    }

    public OptionalConfig<Measure<org.terracotta.common.struct.TimeUnit>> getClientLeaseDuration() {
        return OptionalConfig.of(Setting.CLIENT_LEASE_DURATION, this.clientLeaseDuration);
    }

    public OptionalConfig<Map<String, Measure<MemoryUnit>>> getOffheapResources() {
        return OptionalConfig.of(Setting.OFFHEAP_RESOURCES, this.offheapResources);
    }

    public Cluster setSecurityAuthc(String securityAuthc) {
        this.securityAuthc = securityAuthc;
        return this;
    }

    public Cluster setSecuritySslTls(Boolean securitySslTls) {
        this.securitySslTls = securitySslTls;
        return this;
    }

    public Cluster setSecurityWhitelist(Boolean securityWhitelist) {
        this.securityWhitelist = securityWhitelist;
        return this;
    }

    public Cluster setFailoverPriority(FailoverPriority failoverPriority) {
        this.failoverPriority = Objects.requireNonNull(failoverPriority);
        return this;
    }

    public Cluster setClientReconnectWindow(long clientReconnectWindow, org.terracotta.common.struct.TimeUnit timeUnit) {
        return this.setClientReconnectWindow(Measure.of(clientReconnectWindow, timeUnit));
    }

    public Cluster setClientReconnectWindow(long clientReconnectWindow, TimeUnit jdkUnit) {
        return this.setClientReconnectWindow(Measure.of(clientReconnectWindow, (Enum)org.terracotta.common.struct.TimeUnit.from(jdkUnit).orElseThrow(() -> new IllegalArgumentException(jdkUnit.name()))));
    }

    public Cluster setClientReconnectWindow(Measure<org.terracotta.common.struct.TimeUnit> measure) {
        this.clientReconnectWindow = measure;
        return this;
    }

    public Cluster setClientLeaseDuration(long clientLeaseDuration, org.terracotta.common.struct.TimeUnit timeUnit) {
        return this.setClientLeaseDuration(Measure.of(clientLeaseDuration, timeUnit));
    }

    public Cluster setClientLeaseDuration(long clientLeaseDuration, TimeUnit jdkUnit) {
        return this.setClientLeaseDuration(Measure.of(clientLeaseDuration, (Enum)org.terracotta.common.struct.TimeUnit.from(jdkUnit).orElseThrow(() -> new IllegalArgumentException(jdkUnit.name()))));
    }

    public Cluster setClientLeaseDuration(Measure<org.terracotta.common.struct.TimeUnit> measure) {
        this.clientLeaseDuration = measure;
        return this;
    }

    public Cluster putOffheapResource(String name, long quantity, MemoryUnit memoryUnit) {
        return this.putOffheapResource(name, Measure.of(quantity, memoryUnit));
    }

    public Cluster putOffheapResource(String name, Measure<MemoryUnit> measure) {
        return this.putOffheapResources(Collections.singletonMap(name, measure));
    }

    public Cluster putOffheapResources(Map<String, Measure<MemoryUnit>> offheapResources) {
        if (this.offheapResources == null) {
            this.setOffheapResources(Optional.ofNullable(Setting.OFFHEAP_RESOURCES.getDefaultValue()).orElse(Collections.emptyMap()));
        }
        this.offheapResources.putAll(offheapResources);
        return this;
    }

    public Cluster setOffheapResources(Map<String, Measure<MemoryUnit>> offheapResources) {
        this.offheapResources = offheapResources == null ? null : new ConcurrentHashMap<String, Measure<MemoryUnit>>(offheapResources);
        return this;
    }

    public Cluster removeOffheapResource(String key) {
        Map def;
        if (this.offheapResources == null && (def = (Map)Setting.OFFHEAP_RESOURCES.getDefaultValue()) != null && def.containsKey(key)) {
            this.setOffheapResources(def);
        }
        if (this.offheapResources != null) {
            this.offheapResources.remove(key);
        }
        return this;
    }

    public Cluster unsetOffheapResources() {
        if (this.offheapResources != null) {
            this.setOffheapResources(Collections.emptyMap());
        } else {
            Map def = (Map)Setting.OFFHEAP_RESOURCES.getDefaultValue();
            if (def != null && !def.isEmpty()) {
                this.setOffheapResources(Collections.emptyMap());
            }
        }
        return this;
    }

    public List<Stripe> getStripes() {
        return Collections.unmodifiableList(this.stripes);
    }

    public Cluster setStripes(List<Stripe> stripes) {
        this.stripes = new CopyOnWriteArrayList<Stripe>(stripes);
        return this;
    }

    public Cluster addStripe(Stripe stripe) {
        this.stripes.add(stripe);
        return this;
    }

    public Cluster setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isEmpty() {
        return this.stripes.isEmpty() || this.getNodes().isEmpty();
    }

    public Optional<Node> getSingleNode() throws IllegalStateException {
        return this.getSingleStripe().flatMap(Stripe::getSingleNode);
    }

    public Optional<Stripe> getSingleStripe() {
        if (this.stripes.size() > 1) {
            throw new IllegalStateException();
        }
        if (this.stripes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.stripes.iterator().next());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster that = (Cluster)o;
        return Objects.equals(this.stripes, that.stripes) && Objects.equals(this.name, that.name) && Objects.equals(this.uid, that.uid) && Objects.equals(this.lockContext, that.lockContext) && Objects.equals(this.securitySslTls, that.securitySslTls) && Objects.equals(this.securityWhitelist, that.securityWhitelist) && Objects.equals(this.securityAuthc, that.securityAuthc) && Objects.equals(this.failoverPriority, that.failoverPriority) && Objects.equals(this.clientReconnectWindow, that.clientReconnectWindow) && Objects.equals(this.clientLeaseDuration, that.clientLeaseDuration) && Objects.equals(this.offheapResources, that.offheapResources);
    }

    public int hashCode() {
        return Objects.hash(this.stripes, this.name, this.securityAuthc, this.securitySslTls, this.securityWhitelist, this.uid, this.failoverPriority, this.clientReconnectWindow, this.clientLeaseDuration, this.offheapResources, this.lockContext);
    }

    public String toString() {
        return Props.toString(this.toProperties(false, false, true));
    }

    public String toShapeString() {
        return (this.name == null ? "<no name>" : this.name) + " ( " + this.stripes.stream().map(Stripe::toShapeString).collect(Collectors.joining(", ")) + " )";
    }

    public Collection<Node.Endpoint> getInternalEndpoints() {
        return this.getNodes().stream().map(Node::getInternalEndpoint).collect(Collectors.toList());
    }

    public Collection<Node.Endpoint> getEndpoints(InetSocketAddress initiator) {
        Function<Node, Node.Endpoint> fetcher = this.getEndpointFetcher(initiator);
        return this.getNodes().stream().map(fetcher).collect(Collectors.toList());
    }

    public Collection<Node.Endpoint> getSimilarEndpoints(Node.Endpoint initiator) {
        return this.getNodes().stream().map(node -> node.getSimilarEndpoint(initiator)).collect(Collectors.toList());
    }

    public boolean containsNode(UID nodeUID) {
        return this.getNode(nodeUID).isPresent();
    }

    public boolean containsNode(String nodeName) {
        return this.getNodes().stream().map(Node::getName).anyMatch(Predicate.isEqual(nodeName));
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public Cluster clone() {
        Cluster clone = new Cluster(this.stripes.stream().map(Stripe::clone).collect(Collectors.toList()));
        clone.clientLeaseDuration = this.clientLeaseDuration;
        clone.clientReconnectWindow = this.clientReconnectWindow;
        clone.failoverPriority = this.failoverPriority;
        clone.lockContext = this.lockContext;
        clone.name = this.name;
        clone.uid = this.uid;
        clone.offheapResources = this.offheapResources == null ? null : new ConcurrentHashMap<String, Measure<MemoryUnit>>(this.offheapResources);
        clone.securityAuthc = this.securityAuthc;
        clone.securitySslTls = this.securitySslTls;
        clone.securityWhitelist = this.securityWhitelist;
        return clone;
    }

    public boolean removeStripe(Stripe stripe) {
        return this.stripes.remove(stripe);
    }

    public boolean removeStripe(UID stripeUID) {
        return this.stripes.removeIf(stripe -> stripe.getUID().equals(stripeUID));
    }

    public boolean removeNode(UID uid) {
        boolean detached = this.stripes.stream().anyMatch(stripe -> stripe.removeNode(uid));
        if (detached) {
            this.stripes.removeIf(Stripe::isEmpty);
        }
        return detached;
    }

    public Optional<Node> getNode(UID nodeUID) {
        return this.stripes.stream().flatMap(stripe -> stripe.getNodes().stream()).filter(node -> node.getUID().equals(nodeUID)).findAny();
    }

    public Optional<Node> getNodeByName(String name) {
        return this.stripes.stream().flatMap(stripe -> stripe.getNodes().stream()).filter(node -> node.getName().equals(name)).findAny();
    }

    public Optional<Stripe> getStripe(UID stripeUID) {
        return this.getStripes().stream().filter(s -> s.getUID().equals(stripeUID)).findAny();
    }

    public Optional<Stripe> getStripe(int stripeId) {
        if (stripeId < 1) {
            throw new IllegalArgumentException("Invalid stripe ID: " + stripeId);
        }
        if (stripeId > this.stripes.size()) {
            return Optional.empty();
        }
        return Optional.of(this.stripes.get(stripeId - 1));
    }

    public OptionalInt getStripeId(UID stripeUID) {
        return IntStream.range(0, this.stripes.size()).filter(idx -> this.stripes.get(idx).getUID().equals(stripeUID)).map(idx -> idx + 1).findAny();
    }

    public OptionalInt getStripeIdByNode(UID nodeUID) {
        return IntStream.range(0, this.stripes.size()).filter(idx -> this.stripes.get(idx).containsNode(nodeUID)).map(idx -> idx + 1).findAny();
    }

    public Optional<Stripe> getStripeByNode(UID nodeUID) {
        return this.getStripes().stream().filter(s -> s.containsNode(nodeUID)).findAny();
    }

    public Optional<Stripe> getStripeByNodeName(String nodeName) {
        return this.getStripes().stream().filter(s -> s.containsNode(nodeName)).findAny();
    }

    public int getNodeCount() {
        return this.stripes.stream().mapToInt(Stripe::getNodeCount).sum();
    }

    public int getStripeCount() {
        return this.stripes.size();
    }

    public Collection<Node> getNodes() {
        return this.stripes.stream().flatMap(s -> s.getNodes().stream()).collect(Collectors.toList());
    }

    public void forEach(BiConsumer<Integer, Node> consumer) {
        List<Stripe> stripes = this.getStripes();
        for (int i = 0; i < stripes.size(); ++i) {
            int stripeId = i + 1;
            stripes.get(stripeId - 1).getNodes().forEach((? super T node) -> consumer.accept(stripeId, (Node)node));
        }
    }

    @Override
    public Properties toProperties(boolean expanded, boolean includeDefaultValues, boolean includeHiddenSettings, Version version) {
        Properties properties = Setting.modelToProperties(this, expanded, includeDefaultValues, includeHiddenSettings, version);
        for (int i = 0; i < this.stripes.size(); ++i) {
            String prefix = "stripe." + (i + 1) + ".";
            Properties props = this.stripes.get(i).toProperties(expanded, includeDefaultValues, includeHiddenSettings, version);
            props.stringPropertyNames().forEach((? super T key) -> properties.setProperty(prefix + key, props.getProperty((String)key)));
        }
        return properties;
    }

    @Override
    public Stream<? extends PropertyHolder> descendants() {
        return Stream.concat(this.stripes.stream(), this.stripes.stream().flatMap(Stripe::descendants));
    }

    public Collection<String> getDataDirNames() {
        return this.getNodes().stream().flatMap(node -> node.getDataDirs().orDefault().keySet().stream()).collect(Collectors.toSet());
    }

    public Cluster removeStripes() {
        this.stripes.clear();
        return this;
    }

    public OptionalConfig<LockContext> getConfigurationLockContext() {
        return OptionalConfig.of(Setting.LOCK_CONTEXT, this.lockContext);
    }

    public Cluster setConfigurationLockContext(LockContext lockContext) {
        this.lockContext = lockContext;
        return this;
    }

    public Optional<Stripe> inSameStripe(UID ... nodeUIDs) {
        HashSet<UID> uids = new HashSet<UID>();
        for (UID nodeUID : nodeUIDs) {
            Optional<Stripe> stripe = this.getStripeByNode(nodeUID);
            if (!stripe.isPresent()) {
                return Optional.empty();
            }
            uids.add(stripe.get().getUID());
        }
        return uids.size() == 1 ? Optional.of(uids.iterator().next()).flatMap(this::getStripe) : Optional.empty();
    }

    public UID newUID() {
        UID uuid;
        Set uuids = Stream.concat(Stream.of(this), this.descendants()).map(PropertyHolder::getUID).filter(Objects::nonNull).collect(Collectors.toSet());
        while (uuids.contains(uuid = UID.newUID())) {
        }
        return uuid;
    }

    public UID newUID(Random random) {
        UID uuid;
        Set uuids = Stream.concat(Stream.of(this), this.descendants()).map(PropertyHolder::getUID).filter(Objects::nonNull).collect(Collectors.toSet());
        while (uuids.contains(uuid = UID.newUID(random))) {
        }
        return uuid;
    }

    private Function<Node, Node.Endpoint> getEndpointFetcher(InetSocketAddress initiator) {
        boolean publicAddressConfigured = true;
        for (Node node : this.getNodes()) {
            if (node.getInternalAddress().equals(initiator)) {
                return Node::getInternalEndpoint;
            }
            Optional<InetSocketAddress> publicAddress = node.getPublicAddress();
            publicAddressConfigured &= publicAddress.isPresent();
            if (!publicAddress.isPresent() || !publicAddress.get().equals(initiator)) continue;
            return n -> n.getPublicEndpoint().get();
        }
        return publicAddressConfigured ? n -> n.getPublicEndpoint().get() : Node::getInternalEndpoint;
    }
}

