/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCProtocolException;
import com.tc.util.Assert;
import java.util.zip.Adler32;

public abstract class AbstractTCNetworkHeader
implements TCNetworkHeader {
    protected static final int LENGTH_NOT_AVAIL = -1;
    private static final byte[] EMTPY_BYTE_ARRAY = new byte[0];
    private static final byte[] FOUR_ZERO_BYTES = new byte[]{0, 0, 0, 0};
    protected final int minLength;
    protected final int maxLength;
    protected TCByteBuffer data;
    private final boolean localAllocation;

    protected abstract void setHeaderLength(short var1);

    protected boolean isHeaderLengthAvail() {
        return true;
    }

    protected AbstractTCNetworkHeader(TCByteBuffer buffer, int min, int max) {
        this.minLength = min;
        this.maxLength = max;
        if (buffer == null) {
            this.data = TCByteBufferFactory.getInstance(false, max);
            this.data.limit(min);
            this.localAllocation = true;
        } else {
            this.data = buffer;
            this.localAllocation = false;
        }
        Assert.eval(!this.data.isDirect());
        Assert.eval(this.data.capacity() >= this.maxLength);
        if (this.data.limit() % 4 != 0) {
            throw new AssertionError((Object)("buffer limit not a multiple of 4: " + this.data.limit()));
        }
    }

    protected AbstractTCNetworkHeader(int min, int max) {
        this(null, min, max);
    }

    @Override
    public TCByteBuffer getDataBuffer() {
        return this.data;
    }

    @Override
    public abstract void validate() throws TCProtocolException;

    @Override
    public void recycle() {
        Assert.assertTrue(this.localAllocation);
        if (this.data != null) {
            this.data.recycle();
            this.data = null;
        } else {
            Thread.dumpStack();
        }
    }

    private void setBytes(int pos, byte[] value) {
        this.setBytes(pos, value, 0, value.length);
    }

    private void setBytes(int pos, byte[] value, int offset, int length) {
        this.data.put(pos, value, offset, length);
    }

    protected byte getByte(int index) {
        return this.data.get(index);
    }

    protected byte[] getBytes(int offset, int len) {
        Assert.eval(len >= 0);
        if (0 == len) {
            return EMTPY_BYTE_ARRAY;
        }
        byte[] rv = new byte[len];
        this.data.get(offset, rv, 0, len);
        return rv;
    }

    protected void set4BitValue(int pos, boolean high, byte value) {
        byte other4 = (byte)(this.data.get(pos) & (high ? 15 : 240));
        byte val = (byte)(value << (high ? 4 : 0) & (high ? 240 : 15));
        this.data.put(pos, (byte)(val | other4));
    }

    protected byte get4BitValue(int pos, boolean high) {
        byte bite = this.getByte(pos);
        if (high) {
            return (byte)(bite >> 4 & 0xF);
        }
        return (byte)(bite & 0xF);
    }

    protected long computeAdler32Checksum(int pos, boolean set) {
        Adler32 adler = new Adler32();
        byte[] cksum = this.getBytes(pos, 4);
        this.setBytes(pos, FOUR_ZERO_BYTES);
        adler.update(this.data.array(), 0, this.getHeaderByteLength());
        long rv = adler.getValue();
        if (set) {
            this.data.putUint(pos, rv);
        } else {
            this.setBytes(pos, cksum);
        }
        return rv;
    }

    protected void setLimit(int newLimit) {
        this.data.limit(newLimit);
    }

    public void setOptions(byte[] options) {
        int optionsLen;
        if (options == null) {
            options = new byte[]{};
        }
        Assert.eval((optionsLen = options.length) % 4 == 0);
        Assert.eval(optionsLen <= this.maxLength - this.minLength);
        if (optionsLen > 0) {
            this.setLimit(this.minLength + optionsLen);
            this.setBytes(this.minLength, options);
        } else {
            this.setLimit(this.minLength);
        }
        this.setHeaderLength((byte)((this.minLength + optionsLen) / 4));
    }

    public byte[] getOptions() {
        return this.getBytes(this.minLength, this.getHeaderByteLength() - this.minLength);
    }
}

