/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.inet;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Objects;
import org.terracotta.inet.HostAndIpValidator;

public class InetSocketAddressUtils {
    public static boolean areEqual(InetSocketAddress one, InetSocketAddress two) {
        return Objects.equals(InetSocketAddressUtils.encloseInBracketsIfIpv6(one), InetSocketAddressUtils.encloseInBracketsIfIpv6(two));
    }

    public static InetSocketAddress encloseInBracketsIfIpv6(InetSocketAddress address) {
        if (address != null && HostAndIpValidator.isValidIPv6(address.getHostName(), false)) {
            address = InetSocketAddress.createUnresolved("[" + address.getHostName() + "]", address.getPort());
        }
        return address;
    }

    public static boolean contains(Collection<InetSocketAddress> addresses, InetSocketAddress address) {
        for (InetSocketAddress addr : addresses) {
            if (!InetSocketAddressUtils.areEqual(addr, address)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection<InetSocketAddress> addresses, Collection<InetSocketAddress> subset) {
        for (InetSocketAddress element : subset) {
            if (InetSocketAddressUtils.contains(addresses, element)) continue;
            return false;
        }
        return true;
    }
}

